/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHelper {
    private JavaHelper() {
    }

    public static String dropNonWordCharacterWith(String value, String replacement) {
        if (value == null) {
            return null;
        }
        if (replacement != null) {
            return value.replaceAll("\\W", replacement);
        }
        return JavaHelper.dropNonWordCharacter(value);
    }

    public static String dropNonWordCharacter(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("\\W", "");
    }

    public static String dropNonWordCharacterExcept(String value, String except) {
        if (value == null) {
            return null;
        }
        if (except != null) {
            return value.replaceAll("\\W^" + except, "");
        }
        return JavaHelper.dropNonWordCharacter(value);
    }

    public static String getFileName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return "/" + clazz.getName().replaceAll("[.]", "/") + ".class";
    }

    public static URL getResourceURL(Class<?> clazz) {
        try {
            String name = JavaHelper.getFileName(clazz);
            if (name == null) {
            }
            return clazz.getResource(name);
        }
        finally {
            return null;
        }
    }

    public static URL getFileURL(Class<?> clazz) {
        String name;
        block4: {
            name = JavaHelper.getFileName(clazz);
            if (name != null) break block4;
            return null;
        }
        try {
            URL url = clazz.getResource(name);
            if (url != null) {
                return FileLocator.resolve((URL)url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static List<IFolder> getOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IFolder folder = FileHelper.getFolder(project.getOutputLocation());
        if (folder != null) {
            folders.add(folder);
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = FileHelper.getFolder(entry.getOutputLocation())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<String> getStringOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList outputFoldersAsString = new UniqueEList();
        if (!project.exists()) {
            return outputFoldersAsString;
        }
        List<IFolder> outputFolders = JavaHelper.getOutputFolders(project);
        for (IFolder outputFolder : outputFolders) {
            outputFoldersAsString.add(outputFolder.getFullPath().removeFirstSegments(1).toString());
        }
        return outputFoldersAsString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteJavaResource(IProgressMonitor monitor, IProject project, String folderName, String packageName, String className, boolean deleteParent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        subMonitor.beginTask(null, 300);
        if (project == null || packageName == null) {
            subMonitor.worked(300);
            return false;
        }
        IJavaProject javaProject = null;
        try {
            if (!project.exists()) {
                subMonitor.worked(300);
                return false;
            }
            if (!project.isAccessible()) {
                project.open((IProgressMonitor)subMonitor.newChild(100, 0));
            }
            subMonitor.worked(100);
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
            if (javaProject == null) {
                subMonitor.worked(200);
                return false;
            }
            IFolder root = JavaHelper.getSourceFolder(javaProject, folderName);
            if (root == null) {
                subMonitor.worked(200);
                return false;
            }
            IResource resource = null;
            IContainer container = null;
            if (className != null) {
                IPath targetPath = new Path(FileHelper.convertPackageNameToFolderPath(packageName)).append(String.valueOf(className) + ".java");
                resource = root.findMember(targetPath);
            } else {
                Path targetPath = new Path(FileHelper.convertPackageNameToFolderPath(packageName));
                container = (IContainer)root.findMember((IPath)targetPath);
            }
            if (resource != null && resource.exists()) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, resource, deleteParent);
                return bl;
            }
            if (container != null && container.exists() && (container.members() == null || container.members().length == 0)) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, (IResource)container, deleteParent);
                return bl;
            }
            subMonitor.worked(200);
            return true;
        }
        finally {
            try {
                if (javaProject != null) {
                    javaProject.close();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean moveJavaResource(IProgressMonitor monitor, IProject project, String folderName, String oldPackageName, String oldClassName, String newPackageName, String newClassName, boolean deleteParent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        subMonitor.beginTask(null, 300);
        if (project == null || oldPackageName == null || newPackageName == null) {
            subMonitor.worked(300);
            return false;
        }
        IJavaProject javaProject = null;
        try {
            if (!project.exists()) {
                subMonitor.worked(300);
                return false;
            }
            if (!project.isAccessible()) {
                project.open((IProgressMonitor)subMonitor.newChild(100, 0));
            }
            subMonitor.worked(100);
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
            if (javaProject == null) {
                subMonitor.worked(200);
                return false;
            }
            IFolder root = JavaHelper.getSourceFolder(javaProject, folderName);
            if (root == null) {
                subMonitor.worked(200);
                return false;
            }
            IResource resourceToMove = null;
            IContainer container = null;
            if (oldClassName != null) {
                resourceToMove = root.findMember(new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)).append(String.valueOf(oldClassName) + ".java"));
                container = (IContainer)root.findMember((IPath)new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)));
            } else {
                resourceToMove = root.findMember((IPath)new Path(FileHelper.convertPackageNameToFolderPath(oldPackageName)));
                if (resourceToMove != null && resourceToMove.exists()) {
                    container = resourceToMove.getParent();
                }
            }
            if (resourceToMove == null || !resourceToMove.exists()) {
                subMonitor.worked(200);
                return false;
            }
            if (newClassName != null) {
                IPath targetPath = new Path(FileHelper.convertPackageNameToFolderPath(newPackageName)).append(String.valueOf(newClassName) + ".java");
                IFile targetResource = root.getFile(targetPath);
                if (targetResource.exists()) {
                    boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(200, 0), root, resourceToMove, deleteParent);
                    return bl;
                }
                FileHelper.createContainers((IProgressMonitor)new NullProgressMonitor(), (IResource)targetResource);
                resourceToMove.move(targetResource.getFullPath(), false, (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                IPath targetPath = root.getFullPath().append((IPath)new Path(FileHelper.convertPackageNameToFolderPath(newPackageName)));
                resourceToMove.move(targetPath, false, (IProgressMonitor)subMonitor.newChild(100, 0));
            }
            if (container != null && container.exists() && (container.members() == null || container.members().length == 0)) {
                boolean bl = FileHelper.deleteIResource((IProgressMonitor)subMonitor.newChild(100, 0), root, (IResource)container, deleteParent);
                return bl;
            }
            subMonitor.worked(100);
            return true;
        }
        finally {
            try {
                if (javaProject != null) {
                    javaProject.close();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public static IFile getSourceFile(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null || !(resource instanceof IFile)) continue;
            return (IFile)resource;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null) continue;
            return folder;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, String name) throws CoreException {
        if (project == null || name == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public static List<IFolder> getSourceFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = FileHelper.getFolder(entry.getPath())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<IFolder> getSourceAndOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        folders.addAll(JavaHelper.getSourceFolders(project));
        folders.addAll(JavaHelper.getOutputFolders(project));
        return folders;
    }
}

