/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoConfiguration;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoPartitionScanner;
import org.eclipse.acceleo.internal.ide.ui.preferences.AcceleoColorMessages;
import org.eclipse.acceleo.internal.ide.ui.preferences.ColorButton;
import org.eclipse.acceleo.internal.ide.ui.preferences.ProxyPreferenceStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.Preferences;

public class AcceleoEditorColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IEclipsePreferences defaultScope;
    private IEclipsePreferences instanceScope;
    private ProxyPreferenceStore proxyScope;
    private TreeViewer colorViewer;
    private List<ColorCategory> colorCategories;
    private ColorButton colorButton;

    public void init(IWorkbench workbench) {
        this.defaultScope = new DefaultScope().getNode("org.eclipse.acceleo.ide.ui");
        this.instanceScope = new InstanceScope().getNode("org.eclipse.acceleo.ide.ui");
        this.proxyScope = new ProxyPreferenceStore(this.instanceScope, this.defaultScope);
        AcceleoColor[] templateColors = new AcceleoColor[]{AcceleoColor.TEMPLATE, AcceleoColor.TEMPLATE_NAME, AcceleoColor.TEMPLATE_PARAMETER, AcceleoColor.TEMPLATE_OCL_EXPRESSION, AcceleoColor.TEMPLATE_OCL_KEYWORD};
        ColorCategory templateCategory = new ColorCategory(AcceleoColorMessages.getString("org.eclipse.acceleo.template.category"), templateColors);
        AcceleoColor[] queryColors = new AcceleoColor[]{AcceleoColor.QUERY, AcceleoColor.QUERY_NAME, AcceleoColor.QUERY_PARAMETER, AcceleoColor.QUERY_RETURN};
        ColorCategory queryCategory = new ColorCategory(AcceleoColorMessages.getString("org.eclipse.acceleo.query.category"), queryColors);
        AcceleoColor[] generalColors = new AcceleoColor[]{AcceleoColor.COMMENT, AcceleoColor.MODULE_NAME, AcceleoColor.FOR, AcceleoColor.IF, AcceleoColor.LET, AcceleoColor.DEFAULT, AcceleoColor.KEYWORD, AcceleoColor.LITERAL, AcceleoColor.OCL_EXPRESSION, AcceleoColor.OCL_KEYWORD, AcceleoColor.VARIABLE, AcceleoColor.PROTECTED_AREA};
        ColorCategory generalCategory = new ColorCategory(AcceleoColorMessages.getString("org.eclipse.acceleo.general.category"), generalColors);
        this.colorCategories = new ArrayList<ColorCategory>();
        this.colorCategories.add(templateCategory);
        this.colorCategories.add(queryCategory);
        this.colorCategories.add(generalCategory);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.proxyScope.resetToDefault();
    }

    public boolean performOk() {
        this.proxyScope.propagate();
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        PreferenceLinkArea textEditorLink = new PreferenceLinkArea(parent, 0, "org.eclipse.ui.preferencePages.GeneralTextEditor", AcceleoUIMessages.getString("AcceleoEditorColoringPreferencePage.link"), (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData linkGrid = new GridData();
        linkGrid.grabExcessHorizontalSpace = true;
        linkGrid.horizontalSpan = 3;
        linkGrid.horizontalAlignment = 4;
        textEditorLink.getControl().setLayoutData((Object)linkGrid);
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Label foregroundLabel = new Label(colorComposite, 16384);
        foregroundLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoEditorColoringPreferencePage.foreground.label")) + ':');
        foregroundLabel.setLayoutData((Object)new GridData(768));
        Composite preferenceEditComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        preferenceEditComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        preferenceEditComposite.setLayoutData((Object)gd);
        this.colorViewer = new TreeViewer(preferenceEditComposite, 2564);
        this.colorViewer.setLabelProvider((IBaseLabelProvider)new ColorViewerLabelProvider());
        this.colorViewer.setContentProvider((IContentProvider)new ColorViewerContentProvider());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.colorViewer.getControl().setLayoutData((Object)gd);
        this.colorViewer.setInput(this.colorCategories);
        Composite styleComposite = new Composite(preferenceEditComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        styleComposite.setLayout((Layout)layout);
        styleComposite.setLayoutData((Object)new GridData(1808));
        Label colorChoiceLabel = new Label(styleComposite, 16384);
        colorChoiceLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoEditorColoringPreferencePage.color.label")) + ':');
        gd = new GridData();
        gd.horizontalAlignment = 1;
        colorChoiceLabel.setLayoutData((Object)gd);
        this.colorButton = new ColorButton(styleComposite);
        Button foregroundButton = this.colorButton.getButton();
        foregroundButton.setEnabled(false);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundButton.setLayoutData((Object)gd);
        Label previewLabel = new Label(colorComposite, 16384);
        previewLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoEditorColoringPreferencePage.preview.label")) + ':');
        previewLabel.setLayoutData((Object)new GridData(768));
        Control previewEditor = this.createPreviewViewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewEditor.setLayoutData((Object)gd);
        this.colorViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleoEditorColoringPreferencePage.this.handleColorSelection();
            }
        });
        foregroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoEditorColoringPreferencePage.this.handleColorChange();
            }
        });
        return colorComposite;
    }

    private void handleColorSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.colorViewer.getSelection();
        if (selection.getFirstElement() instanceof ColorItem) {
            ColorItem colorItem = (ColorItem)selection.getFirstElement();
            this.colorButton.getButton().setEnabled(true);
            this.colorButton.setColorValue(this.getRGB(colorItem.getColor()));
        } else {
            this.colorButton.getButton().setEnabled(false);
        }
    }

    private void handleColorChange() {
        IStructuredSelection selection = (IStructuredSelection)this.colorViewer.getSelection();
        if (selection.getFirstElement() instanceof ColorItem) {
            ColorItem colorItem = (ColorItem)selection.getFirstElement();
            RGB rgb = this.colorButton.getColorValue();
            String rgbString = StringConverter.asString((RGB)rgb);
            this.proxyScope.put(colorItem.getColor().getPreferenceKey(), rgbString);
        }
    }

    private RGB getRGB(AcceleoColor color) {
        IPreferencesService service = Platform.getPreferencesService();
        String defaultValue = StringConverter.asString((RGB)color.getDefault());
        String value = service.get(color.getPreferenceKey(), defaultValue, (Preferences[])this.getPreferenceLookupOrder());
        RGB rgbValue = StringConverter.asRGB((String)value);
        return rgbValue;
    }

    private IEclipsePreferences[] getPreferenceLookupOrder() {
        return new IEclipsePreferences[]{this.proxyScope, this.instanceScope, this.defaultScope};
    }

    private Control createPreviewViewer(Composite parent) {
        final SourceViewer previewViewer = new SourceViewer(parent, null, null, false, 2816);
        final AcceleoConfiguration configuration = new AcceleoConfiguration(AcceleoUIActivator.getDefault().getPreferenceStore(), this.getPreferenceLookupOrder());
        Document document = new Document();
        previewViewer.setDocument((IDocument)document);
        previewViewer.configure((SourceViewerConfiguration)configuration);
        previewViewer.setEditable(false);
        String previewContent = AcceleoColorMessages.getString("editor.preview");
        document.set(previewContent);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AcceleoPartitionScanner(), AcceleoPartitionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        final IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                configuration.adaptToPreferenceChanges(event);
                previewViewer.invalidateTextPresentation();
            }
        };
        this.proxyScope.addPreferenceChangeListener(preferenceListener);
        previewViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AcceleoEditorColoringPreferencePage.this.proxyScope.removePreferenceChangeListener(preferenceListener);
            }
        });
        return previewViewer.getControl();
    }

    private class ColorCategory {
        private final ColorItem[] children;
        private final String displayName;

        public ColorCategory(String displayName, AcceleoColor[] children) {
            this.displayName = displayName;
            this.children = new ColorItem[children.length];
            int i = 0;
            while (i < children.length) {
                this.children[i] = new ColorItem(this, children[i]);
                ++i;
            }
        }

        public String getName() {
            return this.displayName;
        }

        public ColorItem[] getChildren() {
            return this.children;
        }
    }

    private class ColorItem {
        private final ColorCategory category;
        private final AcceleoColor color;

        public ColorItem(ColorCategory category, AcceleoColor color) {
            this.category = category;
            this.color = color;
        }

        public AcceleoColor getColor() {
            return this.color;
        }

        public String getName() {
            return AcceleoColorMessages.getString(this.color.getPreferenceKey());
        }

        public ColorCategory getCategory() {
            return this.category;
        }
    }

    private class ColorViewerContentProvider
    implements ITreeContentProvider {
        private ColorViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List input = (List)inputElement;
                return input.toArray(new ColorCategory[input.size()]);
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ColorCategory) {
                return ((ColorCategory)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ColorItem) {
                return ((ColorItem)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ColorCategory;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ColorViewerLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorViewerLabelProvider() {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ColorCategory) {
                return ((ColorCategory)element).getName();
            }
            return ((ColorItem)element).getName();
        }
    }
}

