/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.editor.hierarchy.AbstractHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyNodeReference;
import org.eclipse.xtext.ide.editor.hierarchy.ICallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class DefaultCallHierarchyBuilder
extends AbstractHierarchyBuilder
implements ICallHierarchyBuilder {
    @Accessors
    private ICallHierarchyBuilder.CallHierarchyType hierarchyType = ICallHierarchyBuilder.CallHierarchyType.CALLER;

    @Override
    public Collection<IHierarchyNode> buildRoots(URI rootURI, IProgressMonitor monitor) {
        IEObjectDescription rootDeclaration = this.findDeclaration(rootURI);
        if (rootDeclaration == null) {
            return CollectionLiterals.emptyList();
        }
        IHierarchyNode _createRoot = this.createRoot(rootDeclaration);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IHierarchyNode[]{_createRoot}));
    }

    @Override
    public Collection<IHierarchyNode> buildChildren(IHierarchyNode parent, IProgressMonitor monitor) {
        boolean _not;
        boolean _mayHaveChildren = parent.mayHaveChildren();
        boolean bl = _not = !_mayHaveChildren;
        if (_not) {
            return CollectionLiterals.emptyList();
        }
        LinkedHashMap children = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        Procedures.Procedure2 _function = (declaration, reference) -> {
            IHierarchyNode childNode = this.createChild(children, (IEObjectDescription)declaration, parent);
            if (childNode != null) {
                Collection<IHierarchyNodeReference> _references = childNode.getReferences();
                IHierarchyNodeReference _createNodeReference = this.createNodeReference((IReferenceDescription)reference);
                _references.add(_createNodeReference);
            }
        };
        this.findDeclarations(parent, monitor, (Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription>)_function);
        return children.values();
    }

    protected void findDeclarations(IHierarchyNode parent, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        ICallHierarchyBuilder.CallHierarchyType hierarchyType = this.hierarchyType;
        if (hierarchyType != null) {
            switch (hierarchyType) {
                case CALLEE: {
                    this.findTargetDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
                    break;
                }
                default: {
                    this.findSourceDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
                    break;
                }
            }
        } else {
            this.findSourceDeclarations(parent.getElement().getEObjectURI(), monitor, acceptor);
        }
    }

    protected void findTargetDeclarations(URI sourceDeclarationURI, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        IUnitOfWork _function = sourceDeclaration -> {
            Object _xblockexpression = null;
            IResourceServiceProvider.Registry _resourceServiceProviderRegistry = this.getResourceServiceProviderRegistry();
            IAcceptor _function_1 = reference -> {
                boolean _filterReference = this.filterReference((IReferenceDescription)reference);
                if (_filterReference) {
                    IEObjectDescription _findTargetDeclaration = null;
                    if (reference != null) {
                        _findTargetDeclaration = this.findTargetDeclaration((IReferenceDescription)reference);
                    }
                    IEObjectDescription targetDeclaration = _findTargetDeclaration;
                    acceptor.apply((Object)targetDeclaration, reference);
                }
            };
            ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(_resourceServiceProviderRegistry, _function_1);
            this.getReferenceFinder().findAllReferences(sourceDeclaration, (IReferenceFinder.Acceptor)_referenceAcceptor, monitor);
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.readOnly(sourceDeclarationURI, _function);
    }

    protected void findSourceDeclarations(URI targetDeclarationURI, IProgressMonitor monitor, Procedures.Procedure2<? super IEObjectDescription, ? super IReferenceDescription> acceptor) {
        TargetURIs targetURIs = this.collectTargetURIs(targetDeclarationURI);
        IResourceServiceProvider.Registry _resourceServiceProviderRegistry = this.getResourceServiceProviderRegistry();
        IAcceptor _function = reference -> {
            boolean _filterReference = this.filterReference((IReferenceDescription)reference);
            if (_filterReference) {
                IEObjectDescription _findSourceDeclaration = null;
                if (reference != null) {
                    _findSourceDeclaration = this.findSourceDeclaration((IReferenceDescription)reference);
                }
                IEObjectDescription sourceDeclaration = _findSourceDeclaration;
                acceptor.apply((Object)sourceDeclaration, reference);
            }
        };
        ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(_resourceServiceProviderRegistry, _function);
        this.getReferenceFinder().findAllReferences(targetURIs, this.getResourceAccess(), this.getIndexData(), (IReferenceFinder.Acceptor)_referenceAcceptor, monitor);
    }

    protected TargetURIs collectTargetURIs(URI targetURI) {
        TargetURIs targetURIs = (TargetURIs)this.getTargetURIProvider().get();
        if (targetURI == null) {
            return targetURIs;
        }
        IUnitOfWork _function = targetObject -> {
            if (targetObject == null) {
                return targetURIs;
            }
            this.getTargetURICollector().add(targetObject, targetURIs);
            return targetURIs;
        };
        return (TargetURIs)this.readOnly(targetURI, _function);
    }

    protected boolean filterReference(IReferenceDescription reference) {
        return reference != null;
    }

    protected IEObjectDescription findDeclaration(URI objectURI) {
        return this.getDescription(objectURI);
    }

    protected IEObjectDescription findTargetDeclaration(IReferenceDescription reference) {
        return this.findDeclaration(reference.getTargetEObjectUri());
    }

    protected IEObjectDescription findSourceDeclaration(IReferenceDescription reference) {
        return this.findDeclaration(reference.getContainerEObjectURI());
    }

    protected IHierarchyNode createRoot(IEObjectDescription declaration) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setElement(declaration);
        node.setMayHaveChildren(true);
        return node;
    }

    protected IHierarchyNode createChild(IEObjectDescription declaration, IHierarchyNode parent) {
        DefaultHierarchyNode node = new DefaultHierarchyNode();
        node.setParent(parent);
        node.setElement(declaration);
        boolean _isRecursive = node.isRecursive();
        boolean _not = !_isRecursive;
        node.setMayHaveChildren(_not);
        return node;
    }

    protected IHierarchyNode createChild(Map<URI, IHierarchyNode> children, IEObjectDescription declaration, IHierarchyNode parent) {
        if (declaration == null) {
            return null;
        }
        IHierarchyNode childNode = children.get(declaration.getEObjectURI());
        if (childNode == null) {
            childNode = this.createChild(declaration, parent);
            children.put(declaration.getEObjectURI(), childNode);
        }
        return childNode;
    }

    protected IHierarchyNodeReference createNodeReference(IReferenceDescription reference) {
        IUnitOfWork _function = sourceObject -> {
            ITextRegionWithLineInformation textRegion = this.getTextRegion((EObject)sourceObject, reference.getEReference(), reference.getIndexInList());
            String text = this.getText((EObject)sourceObject, textRegion);
            return new DefaultHierarchyNodeReference(text, textRegion, reference);
        };
        return (IHierarchyNodeReference)this.readOnly(reference.getSourceEObjectUri(), _function);
    }

    protected ITextRegionWithLineInformation getTextRegion(EObject obj, EReference reference, int indexInList) {
        return this.getHierarchyNodeLocationProvider().getTextRegion(obj, (EStructuralFeature)reference, indexInList);
    }

    protected String getText(EObject obj, ITextRegionWithLineInformation textRegion) {
        if (obj == null || textRegion == ITextRegionWithLineInformation.EMPTY_REGION) {
            return "";
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)EcoreUtil.getRootContainer((EObject)obj));
        if (node == null) {
            return "";
        }
        int _offset = textRegion.getOffset();
        int _length = textRegion.getLength();
        int endOffset = _offset + _length;
        return node.getRootNode().getText().substring(textRegion.getOffset(), endOffset);
    }

    @Override
    @Pure
    public ICallHierarchyBuilder.CallHierarchyType getHierarchyType() {
        return this.hierarchyType;
    }

    @Override
    public void setHierarchyType(ICallHierarchyBuilder.CallHierarchyType hierarchyType) {
        this.hierarchyType = hierarchyType;
    }
}

