/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ExternalSchemaLocationProviderRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.XMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDocumentLoader {
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/externalSchemaLocation"));
    protected Document document;
    protected ModelQuery modelQuery;
    protected CMDocumentManager cmDocumentManager;
    protected boolean isInferredGrammarEnabled = true;
    protected CMDocumentLoadingNamespaceTable namespaceTable;
    protected int count = 0;
    static /* synthetic */ Class class$0;

    public CMDocumentLoader(Document document, ModelQuery modelQuery) {
        this(document, modelQuery.getCMDocumentManager());
    }

    public CMDocumentLoader(Document document, CMDocumentManager cmDocumentManager) {
        this.document = document;
        this.cmDocumentManager = cmDocumentManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCMDocuments() {
        boolean walkDocument;
        block20: {
            block21: {
                IPath path;
                block18: {
                    block19: {
                        walkDocument = false;
                        this.cmDocumentManager.removeAllReferences();
                        String[] doctypeInfo = XMLAssociationProvider.getDoctypeInfo(this.document);
                        if (doctypeInfo == null) break block19;
                        walkDocument = this.handleGrammar(doctypeInfo[0], doctypeInfo[1], "DTD");
                        break block20;
                    }
                    if (this.document.getDoctype() == null) break block21;
                    String internalSubset = this.document.getDoctype().getInternalSubset();
                    if (internalSubset == null || Path.EMPTY.equals((Object)(path = CMDocumentLoader.getInternalSubsetPath(this.document)))) break block20;
                    File subsets = path.removeLastSegments(1).toFile();
                    if (!subsets.exists()) {
                        subsets.mkdir();
                    }
                    FileOutputStream stream = null;
                    try {
                        try {
                            String charset;
                            stream = new FileOutputStream(path.toFile());
                            IAdaptable iAdaptable = (IAdaptable)this.document;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz2;
                                try {
                                    clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz2;
                            }
                            stream.write(internalSubset.getBytes((charset = ((IFile)iAdaptable.getAdapter((Class)clazz)).getCharset()) != null ? charset : "UTF-8"));
                            stream.flush();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (CoreException coreException) {
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        Object var8_11 = null;
                        if (stream == null) break block18;
                    }
                    try {}
                    catch (IOException iOException) {}
                    stream.close();
                }
                walkDocument = this.handleGrammar(path.toPortableString(), path.toFile().toURI().toString(), "DTD");
                break block20;
            }
            Element element = this.getRootElement(this.document);
            if (element != null) {
                this.namespaceTable = new CMDocumentLoadingNamespaceTable(this.document);
                this.namespaceTable.addElement(element);
                if (this.namespaceTable.isNamespaceEncountered()) {
                    walkDocument = true;
                } else {
                    this.namespaceTable = null;
                    walkDocument = this.isInferredGrammarEnabled;
                }
            }
        }
        if (!walkDocument) return;
        if (this.checkExternalSchema()) return;
        this.visitNode(this.document);
    }

    protected boolean checkExternalSchema() {
        boolean externalSchemaLoaded = false;
        if (this.document instanceof IDOMDocument) {
            URI uri;
            String baseLocation = ((IDOMDocument)this.document).getModel().getBaseLocation();
            if (baseLocation == null) {
                return false;
            }
            Path basePath = new Path(baseLocation);
            IFile file = null;
            if (basePath.segmentCount() > 1) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath);
            }
            URI uRI = uri = file == null || !file.isAccessible() ? new File(baseLocation).toURI() : file.getLocationURI();
            if (uri != null) {
                IExternalSchemaLocationProvider[] providers = ExternalSchemaLocationProviderRegistry.getInstance().getProviders();
                int i = 0;
                while (i < providers.length) {
                    long diff;
                    long time = _trace ? System.currentTimeMillis() : 0L;
                    Map locations = providers[i].getExternalSchemaLocation(uri);
                    if (_trace && (diff = System.currentTimeMillis() - time) > 250L) {
                        Logger.log(1, "Schema location provider took [" + diff + "ms] for URI [" + uri + "]");
                    }
                    if (locations != null && !locations.isEmpty()) {
                        if (this.namespaceTable != null && this.namespaceTable.isNamespaceEncountered()) {
                            Object schemaLocation = locations.get("http://apache.org/xml/properties/schema/external-schemaLocation");
                            if (schemaLocation != null) {
                                String location = schemaLocation.toString();
                                if (location != null) {
                                    String[] ids = StringUtils.asArray((String)location);
                                    if (ids.length >= 2 && ids.length % 2 == 0) {
                                        if (!externalSchemaLoaded) {
                                            this.cmDocumentManager.removeAllReferences();
                                        }
                                        int j = 0;
                                        while (j < ids.length) {
                                            this.handleGrammar(ids[j], ids[j + 1], "XSD");
                                            externalSchemaLoaded = true;
                                            j += 2;
                                        }
                                    }
                                } else {
                                    Logger.log(204, "External schema location provider did not return an external schema location for IExternalSchemaLocationProvider.SCHEMA_LOCATION: " + providers[i].getClass().getName());
                                }
                            }
                        } else {
                            Object schemaLocation = locations.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
                            if (schemaLocation != null) {
                                this.handleGrammar(uri.toString(), schemaLocation.toString(), "XSD");
                                externalSchemaLoaded = true;
                                break;
                            }
                            Logger.log(204, "External schema location provider did not return an external schema location for IExternalSchemaLocationProvider.NO_NAMESPACE_SCHEMA_LOCATION: " + providers[i].getClass().getName());
                        }
                    }
                    ++i;
                }
            }
        }
        return externalSchemaLoaded;
    }

    public boolean handleGrammar(String publicId, String systemId, String type) {
        boolean result = false;
        int status = this.cmDocumentManager.getCMDocumentStatus(publicId);
        if (status == 0) {
            this.cmDocumentManager.addCMDocumentReference(publicId, systemId, type);
        } else if (status == 4) {
            result = true;
        }
        return result;
    }

    public void handleElement(Element element) {
        this.visitChildNodes(element);
    }

    public void handleElementNS(Element element) {
        this.namespaceTable.addElement(element);
        this.visitChildNodes(element);
    }

    public void visitNode(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            ++this.count;
            Element element = (Element)node;
            if (this.namespaceTable == null) {
                this.handleElement(element);
            } else {
                this.handleElementNS(element);
            }
        } else if (nodeType == 9) {
            this.visitChildNodes(node);
        }
    }

    protected void visitChildNodes(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            this.visitNode(child);
            child = child.getNextSibling();
        }
    }

    protected Element getRootElement(Document document) {
        Element result = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                result = (Element)node;
                break;
            }
            ++i;
        }
        return result;
    }

    static IPath getInternalSubsetPath(Document document) {
        Path path = Path.EMPTY;
        if (document instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)document;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IFile) {
                CRC32 calc = new CRC32();
                calc.update(resource.getFullPath().toString().getBytes());
                path = XMLCorePlugin.getDefault().getStateLocation().append("internalsubsets").append(String.valueOf(calc.getValue()) + ".dtd");
            }
        }
        return path;
    }

    protected class CMDocumentLoadingNamespaceTable
    extends NamespaceTable {
        protected List newNamespaceList;

        public CMDocumentLoadingNamespaceTable(Document document) {
            super(document);
        }

        public void addElement(Element element) {
            this.newNamespaceList = null;
            super.addElement(element);
            if (this.newNamespaceList != null) {
                Iterator i = this.newNamespaceList.iterator();
                while (i.hasNext()) {
                    NamespaceInfo info = (NamespaceInfo)i.next();
                    CMDocumentLoader.this.handleGrammar(info.uri, info.locationHint, "XSD");
                }
            }
        }

        protected void internalAddNamespaceInfo(String key, NamespaceInfo info) {
            super.internalAddNamespaceInfo(key, info);
            if (this.newNamespaceList == null) {
                this.newNamespaceList = new ArrayList();
            }
            this.newNamespaceList.add(info);
        }
    }
}

