/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectMove;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.swt.model.layout.ILayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.ILayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;
import org.eclipse.wb.internal.xwt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.xwt.model.layout.LayoutPresentation;
import org.eclipse.wb.internal.xwt.model.layout.VirtualLayoutDataCreationSupport;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutInfo
extends XmlObjectInfo
implements ILayoutInfo<ControlInfo> {
    private static String KEY_DONT_CREATE_VIRTUAL_DATA = "don't create virtual LayoutData for this Control_Info";
    private static final String KEY_LAYOUT_DATA_HAS = "layout-data.has";
    private static final String KEY_LAYOUT_DATA_CLASS = "layout-data.class";
    private Class<?> m_layoutDataClass;
    private Object m_layoutDataVirtualObject;
    private ComplexProperty m_layoutComplexProperty;

    public LayoutInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.addBroadcasts();
        this.contributeLayoutProperty_toComposite();
        this.contributeToClipboardCopy();
    }

    private void addBroadcasts() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                if (LayoutInfo.this.isActive()) {
                    LayoutInfo.this.ensureLayoutDatas();
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildAddAfter(){

            public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (LayoutInfo.this.getContext().isParsing()) {
                    return;
                }
                if (LayoutInfo.this.isActiveOnComposite(parent) && LayoutInfo.this.isManagedObject(child)) {
                    LayoutInfo.this.ensureLayoutData((ControlInfo)child);
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                LayoutInfo.this.handle_maybe_removeControl_before(parent, child, false);
                if (child == LayoutInfo.this) {
                    LayoutInfo.this.onDelete();
                }
            }

            public void after(ObjectInfo parent, ObjectInfo child) throws Exception {
                LayoutInfo.this.handle_maybe_removeControl_after(parent, child);
            }
        });
        this.addBroadcastListener(new XmlObjectMove(){

            public void before(XmlObjectInfo child, ObjectInfo oldParent, ObjectInfo newParent) throws Exception {
                if (newParent != oldParent) {
                    LayoutInfo.this.handle_maybe_removeControl_before(oldParent, (ObjectInfo)child, true);
                }
            }

            public void after(XmlObjectInfo child, ObjectInfo oldParent, ObjectInfo newParent) throws Exception {
                if (newParent != oldParent) {
                    LayoutInfo.this.handle_maybe_removeControl_after(oldParent, (ObjectInfo)child);
                }
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void childRemoveAfter(ObjectInfo parent, ObjectInfo child) throws Exception {
                ControlInfo control;
                if (child instanceof LayoutDataInfo && LayoutInfo.this.isManagedObject(parent) && LayoutInfo.this.shouldCreateLayoutData(control = (ControlInfo)parent)) {
                    LayoutInfo.this.ensureLayoutData(control);
                }
            }
        });
    }

    private void handle_maybe_removeControl_before(ObjectInfo parent, ObjectInfo child, boolean deleteLayoutData) throws Exception {
        if (this.isActiveOnComposite(parent) && this.isManagedObject(child)) {
            ControlInfo control = (ControlInfo)child;
            this.onControlRemoveBefore(control);
            if (deleteLayoutData) {
                this.deleteLayoutData(control);
            }
        }
    }

    private void handle_maybe_removeControl_after(ObjectInfo parent, ObjectInfo child) throws Exception {
        if (this.isActiveOnComposite(parent) && child instanceof ControlInfo) {
            ControlInfo control = (ControlInfo)child;
            this.onControlRemoveAfter(control);
        }
    }

    private void contributeLayoutProperty_toComposite() {
        this.addBroadcastListener(new XmlObjectAddProperties(){

            public void invoke(XmlObjectInfo object, List<Property> properties) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)object)) {
                    LayoutInfo.this.addLayoutProperty(properties);
                }
            }
        });
    }

    public void onSet() throws Exception {
        this.ensureLayoutDatas();
    }

    protected void onDelete() throws Exception {
        for (ControlInfo control : this.getControls()) {
            this.deleteLayoutData(control);
        }
    }

    protected void onControlRemoveBefore(ControlInfo control) throws Exception {
    }

    protected void onControlRemoveAfter(ControlInfo control) throws Exception {
    }

    private boolean shouldCreateLayoutData(ControlInfo control) {
        return !control.isDeleting() && control.getArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA) == null;
    }

    protected void deleteLayoutData(ControlInfo control) throws Exception {
        control.putArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA, Boolean.TRUE);
        try {
            LayoutDataInfo layoutData = LayoutInfo.getLayoutData(control);
            if (layoutData != null) {
                layoutData.delete();
                if (!layoutData.isDeleted()) {
                    control.removeChild((ObjectInfo)layoutData);
                }
            }
        }
        finally {
            control.removeArbitraryValue(KEY_DONT_CREATE_VIRTUAL_DATA);
        }
    }

    public static LayoutDataInfo getLayoutData(ControlInfo control) {
        for (ObjectInfo object : control.getChildren()) {
            if (!(object instanceof LayoutDataInfo)) continue;
            return (LayoutDataInfo)object;
        }
        return null;
    }

    public ILayoutDataInfo getLayoutData2(IControlInfo control) {
        return LayoutInfo.getLayoutData((ControlInfo)control);
    }

    private void ensureLayoutDatas() throws Exception {
        for (ControlInfo control : this.getControls()) {
            this.ensureLayoutData(control);
        }
    }

    private void ensureLayoutData(ControlInfo control) throws Exception {
        LayoutDataInfo layoutData;
        if (this.hasLayoutData() && (layoutData = LayoutInfo.getLayoutData(control)) == null) {
            this.createVirtualLayoutData(control);
        }
    }

    private void createVirtualLayoutData(ControlInfo control) throws Exception {
        Object dataObject = this.getLayoutDataVirtualObject();
        VirtualLayoutDataCreationSupport creationSupport = new VirtualLayoutDataCreationSupport(control, dataObject);
        LayoutDataInfo layoutData = (LayoutDataInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), this.getLayoutDataClass(), (CreationSupport)creationSupport);
        control.addChild((ObjectInfo)layoutData);
    }

    private boolean hasLayoutData() {
        return XmlObjectUtils.hasTrueParameter((XmlObjectInfo)this, (String)KEY_LAYOUT_DATA_HAS);
    }

    private Class<?> getLayoutDataClass() throws Exception {
        if (this.m_layoutDataClass == null) {
            String layoutDataClassName = XmlObjectUtils.getParameter((XmlObjectInfo)this, (String)KEY_LAYOUT_DATA_CLASS);
            Assert.isTrue2((!StringUtils.isEmpty((String)layoutDataClassName) ? 1 : 0) != 0, (String)"No 'layout-data.class' parameter for {0}.", (Object[])new Object[]{this});
            this.m_layoutDataClass = this.getContext().getClassLoader().loadClass(layoutDataClassName);
        }
        return this.m_layoutDataClass;
    }

    protected final Object getLayoutDataVirtualObject() throws Exception {
        if (this.m_layoutDataVirtualObject == null) {
            String script = XmlObjectUtils.getParameter((XmlObjectInfo)this, (String)"layout-data.virtual");
            Assert.isNotNull2((Object)script, (String)"No 'layout-data.virtual' script for creating virtual LayoutData object. {0}", (Object[])new Object[]{this});
            script = StringUtils.replace((String)script, (String)"%LDC%", (String)this.getLayoutDataClass().getName());
            this.m_layoutDataVirtualObject = ScriptUtils.evaluate((ClassLoader)this.getContext().getClassLoader(), (String)script);
        }
        return this.m_layoutDataVirtualObject;
    }

    public final IObjectPresentation getPresentation() {
        return new LayoutPresentation(this);
    }

    public final CompositeInfo getComposite() {
        return (CompositeInfo)this.getParent();
    }

    public final boolean isActive() {
        CompositeInfo composite = this.getComposite();
        return this.isActiveOnComposite((ObjectInfo)composite);
    }

    private boolean isActiveOnComposite(ObjectInfo composite) {
        return composite != null && composite.getChildren().contains((Object)this);
    }

    public boolean isManagedObject(Object object) {
        if (object instanceof ControlInfo && this.isActive() && this.getComposite().getChildren().contains(object)) {
            ControlInfo control = (ControlInfo)((Object)object);
            return !control.isDeleted();
        }
        return false;
    }

    public final ControlInfo getControl(Object object) {
        return (ControlInfo)((Object)object);
    }

    public final List<ControlInfo> getControls() {
        ArrayList controls = Lists.newArrayList();
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            if (!this.isManagedObject((Object)control)) continue;
            controls.add(control);
        }
        return controls;
    }

    private void addLayoutProperty(List<Property> properties) throws Exception {
        if (this.m_layoutComplexProperty == null) {
            Class componentClass = this.getDescription().getComponentClass();
            String text = componentClass != null ? "(" + componentClass.getName() + ")" : "(absolute)";
            this.m_layoutComplexProperty = new ComplexProperty("Layout", text){

                public boolean isModified() throws Exception {
                    return true;
                }

                public void setValue(Object value) throws Exception {
                    if (value == UNKNOWN_VALUE) {
                        LayoutInfo.this.delete();
                    }
                }
            };
            this.m_layoutComplexProperty.setCategory(PropertyCategory.system((int)5));
            this.m_layoutComplexProperty.setEditorPresentation((PropertyEditorPresentation)new ButtonPropertyEditorPresentation(){

                protected Image getImage() {
                    return DesignerPlugin.getImage((String)"properties/down.png");
                }

                protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
                    MenuManager manager = new MenuManager();
                    LayoutInfo.this.getComposite().fillLayoutsManager((IMenuManager)manager);
                    Menu menu = manager.createContextMenu((Control)propertyTable);
                    UiUtils.showAndDisposeOnHide((Menu)menu);
                }
            });
        }
        this.m_layoutComplexProperty.setProperties(this.getProperties());
        properties.add((Property)this.m_layoutComplexProperty);
    }

    public void command_CREATE(ControlInfo control, ControlInfo nextControl) throws Exception {
        XmlObjectUtils.add((XmlObjectInfo)control, (Association)Associations.direct(), (XmlObjectInfo)this.getComposite(), (XmlObjectInfo)nextControl);
    }

    public void command_MOVE(ControlInfo control, ControlInfo nextControl) throws Exception {
        XmlObjectUtils.move((XmlObjectInfo)control, (Association)Associations.direct(), (XmlObjectInfo)this.getComposite(), (XmlObjectInfo)nextControl);
    }

    private void contributeToClipboardCopy() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                if (LayoutInfo.this.isActiveOnComposite((ObjectInfo)object)) {
                    LayoutInfo.this.clipboardCopy_addCompositeCommands(commands);
                }
            }
        });
    }

    protected void clipboardCopy_addCompositeCommands(List<ClipboardCommand> commands) throws Exception {
        for (ControlInfo control : this.getControls()) {
            this.clipboardCopy_addControlCommands(control, commands);
        }
    }

    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
    }
}

