/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class DoubleObjectPropertyEditor
extends AbstractTextPropertyEditor {
    public static final DoubleObjectPropertyEditor INSTANCE = new DoubleObjectPropertyEditor();

    private DoubleObjectPropertyEditor() {
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof Double) {
            return value.toString();
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        Double value;
        if ((text = text.trim()).length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
            return true;
        }
        if (text.equals("null")) {
            property.setValue(null);
            return true;
        }
        try {
            value = Double.valueOf(text);
        }
        catch (Throwable throwable) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.DoubleObjectPropertyEditor_notValidDouble, text));
            return false;
        }
        property.setValue(value);
        return true;
    }
}

