/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import com.google.common.base.Predicate;
import java.util.Iterator;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;

public class ConflictSetIterator
implements Iterator<Activation<?>> {
    private ConflictSet conflictset;
    private Predicate breakCondition;
    private Activation<?> nextActivation;
    private boolean returned = true;

    public ConflictSetIterator(ConflictSet conflictset) {
        this.conflictset = conflictset;
        this.breakCondition = new Predicate(){

            public boolean apply(Object input) {
                return false;
            }
        };
    }

    public ConflictSetIterator(ConflictSet conflictset, Predicate breakCondition) {
        this.conflictset = conflictset;
        this.breakCondition = breakCondition;
    }

    @Override
    public boolean hasNext() {
        if (this.returned) {
            this.nextActivation = this.conflictset.getNextActivation();
            this.returned = false;
        }
        if (this.nextActivation != null) {
            return !this.breakCondition.apply(this.nextActivation.getAtom());
        }
        return false;
    }

    @Override
    public Activation<?> next() {
        this.returned = true;
        return this.nextActivation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Deletion from conflict set is not supported.");
    }
}

