/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.handlers;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternLanguageFactory;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;

public abstract class ShowPatternLocationHandler
extends AbstractHandler {
    @Inject
    protected IURIEditorOpener uriOpener;

    protected void showPatternLocation(ExecutionEvent event, IQuerySpecificationProvider provider) throws ExecutionException {
        if (provider instanceof IPatternBasedSpecificationProvider) {
            IPatternBasedSpecificationProvider patternBasedProvider = (IPatternBasedSpecificationProvider)provider;
            this.uriOpener.open(patternBasedProvider.getSpecificationSourceURI(), true);
        } else {
            ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)provider.getFullyQualifiedName()));
            Pattern p = PatternLanguageFactory.eINSTANCE.createPattern();
            String patternName = (String)list.remove(list.size() - 1);
            p.setName(patternName);
            EMFPatternLanguageJvmModelInferrerUtil inferrerUtil = new EMFPatternLanguageJvmModelInferrerUtil();
            String querySpecificationClassName = inferrerUtil.querySpecificationClassName(p);
            String publicFqn = Joiner.on((String)".").join(Iterables.concat((Iterable)list, (Iterable)ImmutableList.of((Object)"util", (Object)querySpecificationClassName)));
            String privateFqn = Joiner.on((String)".").join(Iterables.concat((Iterable)list, (Iterable)ImmutableList.of((Object)"internal", (Object)querySpecificationClassName)));
            SearchPattern publicPattern = SearchPattern.createPattern((String)publicFqn, (int)5, (int)0, (int)0);
            SearchPattern privatePattern = SearchPattern.createPattern((String)privateFqn, (int)5, (int)0, (int)0);
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            LocationSearchRequestor requestor = new LocationSearchRequestor();
            try {
                new SearchEngine().search(publicPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                if (!requestor.opened) {
                    new SearchEngine().search(privatePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                    if (!requestor.opened) {
                        MessageDialog.openWarning((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)"Show Location", (String)String.format("Cannot open source pattern %s. Is contributing project %s indexed by JDT?", provider.getFullyQualifiedName(), provider.getSourceProjectName()));
                    }
                }
            }
            catch (CoreException e) {
                throw new ExecutionException("Error while opening editor", (Throwable)e);
            }
        }
    }

    protected static class LocationSearchRequestor
    extends SearchRequestor {
        private boolean opened = false;

        protected LocationSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (!this.opened && element instanceof IJavaElement) {
                this.opened = true;
                JavaUI.openInEditor((IJavaElement)((IJavaElement)element));
            }
        }
    }
}

