/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.data.QuerySpecificationStore;
import org.eclipse.viatra.query.runtime.registry.data.RegistryEntryImpl;
import org.eclipse.viatra.query.runtime.registry.data.RegistrySourceImpl;
import org.eclipse.viatra.query.runtime.registry.impl.FilteringRegistryView;
import org.eclipse.viatra.query.runtime.registry.impl.GlobalRegistryView;
import org.eclipse.viatra.query.runtime.registry.impl.RegistryChangeMultiplexer;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class QuerySpecificationRegistryImpl
implements IQuerySpecificationRegistry {
    private final QuerySpecificationStore querySpecificationStore = new QuerySpecificationStore();
    private final IConnectorListener connectorListener = new RegistryUpdaterConnectorListener();
    private final RegistryChangeMultiplexer multiplexer = new RegistryChangeMultiplexer();
    private final Logger logger = ViatraQueryLoggingUtil.getLogger(IQuerySpecificationRegistry.class);
    private IDefaultRegistryView defaultView = null;

    @Override
    public boolean addSource(IRegistrySourceConnector connector) {
        Preconditions.checkArgument((connector != null ? 1 : 0) != 0, (Object)"Connector cannot be null");
        String identifier = connector.getIdentifier();
        Map<String, RegistrySourceImpl> sources = this.querySpecificationStore.getSources();
        if (sources.containsKey(identifier)) {
            return false;
        }
        RegistrySourceImpl source = new RegistrySourceImpl(identifier, this.querySpecificationStore, connector.includeSpecificationsInDefaultViews());
        sources.put(identifier, source);
        connector.addListener(this.connectorListener);
        this.logger.debug((Object)("Source added: " + source.getIdentifier()));
        return true;
    }

    @Override
    public boolean removeSource(IRegistrySourceConnector connector) {
        Preconditions.checkArgument((connector != null ? 1 : 0) != 0, (Object)"Connector cannot be null");
        String identifier = connector.getIdentifier();
        Map<String, RegistrySourceImpl> sources = this.querySpecificationStore.getSources();
        if (!sources.containsKey(identifier)) {
            return false;
        }
        connector.removeListener(this.connectorListener);
        RegistrySourceImpl source = sources.remove(identifier);
        for (RegistryEntryImpl entry : source.getFqnToEntryMap().values()) {
            this.multiplexer.entryRemoved(entry);
        }
        this.logger.debug((Object)("Source removed: " + source.getIdentifier()));
        return true;
    }

    protected QuerySpecificationStore getStore() {
        return this.querySpecificationStore;
    }

    @Override
    public IRegistryView createView() {
        return this.createGlobalView();
    }

    private GlobalRegistryView createGlobalView() {
        GlobalRegistryView registryView = new GlobalRegistryView(this);
        this.initializeChangeListener(registryView);
        return registryView;
    }

    protected void initializeChangeListener(IQuerySpecificationRegistryChangeListener listener) {
        for (RegistrySourceImpl source : this.querySpecificationStore.getSources().values()) {
            Map<String, RegistryEntryImpl> entryMap = source.getFqnToEntryMap();
            for (RegistryEntryImpl entry : entryMap.values()) {
                listener.entryAdded(entry);
            }
        }
        this.multiplexer.addListener(listener);
    }

    @Override
    public IRegistryView createView(IRegistryViewFilter filter) {
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"Filter cannot be null");
        FilteringRegistryView registryView = new FilteringRegistryView(this, filter, false);
        this.initializeChangeListener(registryView);
        return registryView;
    }

    @Override
    public IDefaultRegistryView getDefaultView() {
        if (this.defaultView == null) {
            this.defaultView = this.createGlobalView();
        }
        return this.defaultView;
    }

    @Override
    public IRegistryView createView(IRegistryViewFactory factory) {
        IRegistryView registryView = factory.createView(this);
        this.initializeChangeListener(registryView);
        return registryView;
    }

    private final class RegistryUpdaterConnectorListener
    implements IConnectorListener {
        private RegistryUpdaterConnectorListener() {
        }

        @Override
        public void querySpecificationAdded(IRegistrySourceConnector connector, IQuerySpecificationProvider specification) {
            String identifier = connector.getIdentifier();
            RegistrySourceImpl source = QuerySpecificationRegistryImpl.this.querySpecificationStore.getSources().get(identifier);
            String fullyQualifiedName = specification.getFullyQualifiedName();
            RegistryEntryImpl registryEntry = new RegistryEntryImpl(source, specification);
            RegistryEntryImpl oldEntry = source.getFqnToEntryMap().put(fullyQualifiedName, registryEntry);
            if (oldEntry != null) {
                QuerySpecificationRegistryImpl.this.logger.warn((Object)String.format("Specification added with existing FQN %s in source %s", fullyQualifiedName, identifier));
                QuerySpecificationRegistryImpl.this.multiplexer.entryRemoved(oldEntry);
            }
            QuerySpecificationRegistryImpl.this.multiplexer.entryAdded(registryEntry);
        }

        @Override
        public void querySpecificationRemoved(IRegistrySourceConnector connector, IQuerySpecificationProvider specification) {
            String identifier = connector.getIdentifier();
            RegistrySourceImpl source = QuerySpecificationRegistryImpl.this.querySpecificationStore.getSources().get(identifier);
            String fullyQualifiedName = specification.getFullyQualifiedName();
            RegistryEntryImpl registryEntry = source.getFqnToEntryMap().remove(fullyQualifiedName);
            if (registryEntry != null) {
                QuerySpecificationRegistryImpl.this.multiplexer.entryRemoved(registryEntry);
            }
        }
    }
}

