/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;

public abstract class BaseQuerySpecification<Matcher extends ViatraQueryMatcher<? extends IPatternMatch>>
implements IQuerySpecification<Matcher> {
    protected final PQuery wrappedPQuery;

    protected static ViatraQueryException processInitializerError(ExceptionInInitializerError err) {
        Throwable cause1 = err.getCause();
        if (cause1 instanceof RuntimeException) {
            Throwable cause2 = ((RuntimeException)cause1).getCause();
            if (cause2 instanceof ViatraQueryException) {
                return (ViatraQueryException)cause2;
            }
            if (cause2 instanceof QueryInitializationException) {
                return new ViatraQueryException((QueryInitializationException)cause2);
            }
        }
        throw err;
    }

    protected abstract Matcher instantiate(ViatraQueryEngine var1) throws ViatraQueryException;

    @Override
    public Matcher instantiate() throws ViatraQueryException {
        return null;
    }

    public BaseQuerySpecification(PQuery wrappedPQuery) {
        this.wrappedPQuery = wrappedPQuery;
        wrappedPQuery.publishedAs().add(this);
    }

    @Override
    public PQuery getInternalQueryRepresentation() {
        return this.wrappedPQuery;
    }

    @Override
    public Matcher getMatcher(ViatraQueryEngine engine) throws ViatraQueryException {
        this.ensureInitializedInternal();
        if (this.wrappedPQuery.getStatus() == PQuery.PQueryStatus.ERROR) {
            String errorMessages = Joiner.on((String)"\n").join(Iterables.transform((Iterable)this.wrappedPQuery.getPProblems(), (Function)new Function<PProblem, String>(){

                public String apply(PProblem input) {
                    return input == null ? "" : input.getShortMessage();
                }
            }));
            throw new ViatraQueryException(String.format("Erroneous query specification: %s %n %s", this.getFullyQualifiedName(), errorMessages), "Cannot initialize matchers on erroneous query specifications.");
        }
        if (!engine.getScope().isCompatibleWithQueryScope(this.getPreferredScopeClass())) {
            throw new ViatraQueryException(String.format("Scope class incompatibility: the query %s is formulated over query scopes of class %s,  thus the query engine formulated over scope %s of class %s cannot evaluate it.", this.getFullyQualifiedName(), this.getPreferredScopeClass().getCanonicalName(), engine.getScope(), engine.getScope().getClass().getCanonicalName()), "Incompatible scope classes of engine and query.");
        }
        return this.instantiate(engine);
    }

    protected void ensureInitializedInternal() throws ViatraQueryException {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new ViatraQueryException(e);
        }
    }

    protected void ensureInitializedInternalSneaky() {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PAnnotation> getAllAnnotations() {
        return this.wrappedPQuery.getAllAnnotations();
    }

    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        return this.wrappedPQuery.getAnnotationsByName(annotationName);
    }

    public PAnnotation getFirstAnnotationByName(String annotationName) {
        return this.wrappedPQuery.getFirstAnnotationByName(annotationName);
    }

    public String getFullyQualifiedName() {
        return this.wrappedPQuery.getFullyQualifiedName();
    }

    public List<String> getParameterNames() {
        return this.wrappedPQuery.getParameterNames();
    }

    public List<PParameter> getParameters() {
        return this.wrappedPQuery.getParameters();
    }

    public Integer getPositionOfParameter(String parameterName) {
        return this.wrappedPQuery.getPositionOfParameter(parameterName);
    }
}

