/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.viewmodel;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.viewmodel.IYSeries;

public class YSeries
implements IYSeries {
    @SerializedName(value="label")
    private final String fLabel;
    @SerializedName(value="yValues")
    private final double[] fYValues;
    @SerializedName(value="type")
    private final String fType;
    @SerializedName(value="color")
    private final @Nullable String fColor;
    @SerializedName(value="width")
    private final int fWidth;
    @SerializedName(value="style")
    private final String fStyle;

    public YSeries(String type, @Nullable String color, int width, @Nullable String lineStyle, String seriesName, double[] yData) {
        this.fType = type;
        this.fColor = color;
        this.fWidth = width;
        this.fLabel = seriesName;
        this.fYValues = yData;
        this.fStyle = lineStyle == null ? "solid" : lineStyle;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public double[] getDatapoints() {
        return this.fYValues;
    }

    @Override
    public String getSeriesType() {
        return this.fType;
    }

    @Override
    public @Nullable String getColor() {
        return this.fColor;
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public @NonNull String getSeriesStyle() {
        return this.fStyle;
    }

    public int hashCode() {
        return Objects.hash(this.fLabel, this.fType, this.fColor, this.fWidth, this.fYValues, this.fStyle);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YSeries other = (YSeries)obj;
        return Objects.equals(this.fLabel, other.fLabel) && Objects.equals(this.fYValues, other.fYValues) && Objects.equals(this.fColor, other.fColor) && Objects.equals(this.fType, other.fType) && Objects.equals(this.fStyle, other.fStyle) && this.fWidth == other.fWidth;
    }
}

