/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.project.model;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.osgi.service.prefs.BackingStoreException;

public final class TraceTypePreferences {
    private static final String SEPARATOR = "::";
    public static final String TRACE_TYPE_PREFERENCE_KEY = "org.eclipse.tracecompass.tmf.core.prefs.traceType";

    public static void init() {
        IEclipsePreferences configurationPreferences = TraceTypePreferences.getEclipsePreference();
        try {
            configurationPreferences.put(TRACE_TYPE_PREFERENCE_KEY, configurationPreferences.get(TRACE_TYPE_PREFERENCE_KEY, TraceTypePreferences.getDefaultValue()));
            configurationPreferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("Failed to initialize trace type preferences", e);
        }
    }

    private static String getDefaultValue() {
        return Joiner.on((String)SEPARATOR).join((Object[])new String[0]);
    }

    public static void setPreferenceValue(List<@NonNull String> disabled) {
        try {
            IEclipsePreferences configurationPreferences = TraceTypePreferences.getEclipsePreference();
            TmfTraceType.getTraceTypeHelpers().forEach(helper -> {
                if (!helper.isExperimentType()) {
                    helper.setEnabled(!disabled.contains(helper.getTraceTypeId()));
                }
            });
            String value = Joiner.on((String)SEPARATOR).join(disabled);
            configurationPreferences.put(TRACE_TYPE_PREFERENCE_KEY, value);
            configurationPreferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("Failed to set the trace type preferences", e);
        }
    }

    private static IEclipsePreferences getEclipsePreference() {
        IEclipsePreferences configurationPreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        return configurationPreferences;
    }

    public static List<String> getPreferenceValue() {
        IEclipsePreferences configurationPreferences = TraceTypePreferences.getEclipsePreference();
        String joined = configurationPreferences.get(TRACE_TYPE_PREFERENCE_KEY, TraceTypePreferences.getDefaultValue());
        Iterable disabled = Splitter.on((String)SEPARATOR).split((CharSequence)joined);
        return Lists.newArrayList((Iterable)disabled);
    }
}

