/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.ITmfXmlTopLevelElement;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public interface IXmlStateSystemContainer
extends ITmfXmlTopLevelElement {
    public static final int ROOT_QUARK = -1;
    public static final int ERROR_QUARK = -1;

    public ITmfStateSystem getStateSystem();

    public @NonNull Iterable<@NonNull TmfXmlLocation> getLocations();

    default public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        return null;
    }

    default public int getQuarkAbsoluteAndAdd(String ... path) {
        ITmfStateSystem stateSystem = this.getStateSystem();
        int quark = stateSystem.optQuarkAbsolute(path);
        if (quark == -2 && stateSystem instanceof ITmfStateSystemBuilder) {
            quark = ((ITmfStateSystemBuilder)stateSystem).getQuarkAbsoluteAndAdd(path);
        }
        return quark;
    }

    default public int getQuarkRelativeAndAdd(int startNodeQuark, String ... path) {
        ITmfStateSystem stateSystem = this.getStateSystem();
        int quark = stateSystem.optQuarkRelative(startNodeQuark, path);
        if (quark == -2 && stateSystem instanceof ITmfStateSystemBuilder) {
            quark = ((ITmfStateSystemBuilder)stateSystem).getQuarkRelativeAndAdd(startNodeQuark, path);
        }
        return quark;
    }
}

