/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class BasicSegment
implements ISegment {
    public static final IHTIntervalReader<BasicSegment> BASIC_SEGMENT_READ_FACTORY = buffer -> new BasicSegment(buffer.getLong(), buffer.getLong());
    private static final long serialVersionUID = -3257452887960883177L;
    private final long fStart;
    private final long fEnd;

    public BasicSegment(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        this.fStart = start;
        this.fEnd = end;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    @Override
    public int getSizeOnDisk() {
        return 16;
    }

    @Override
    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.getStart());
        buffer.putLong(this.getEnd());
    }

    public String toString() {
        return new String(String.valueOf('[') + String.valueOf(this.fStart) + ", " + String.valueOf(this.fEnd) + ']');
    }
}

