/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import java.util.ArrayList;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IRepositoryContentFilter;
import org.eclipse.team.svn.ui.repository.model.IResourceTreeNode;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class RepositoryContentProvider
extends WorkbenchContentProvider {
    protected RepositoryTreeViewer repositoryTree;
    protected IRepositoryContentFilter filter;

    public RepositoryContentProvider(RepositoryTreeViewer repositoryTree) {
        this.repositoryTree = repositoryTree;
    }

    public IRepositoryContentFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IRepositoryContentFilter filter) {
        this.filter = filter;
    }

    public boolean hasChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter instanceof IParentTreeNode) {
            return ((IParentTreeNode)adapter).hasChildren();
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        IWorkbenchAdapter adapter = this.getAdapter(parentElement);
        if (adapter instanceof IParentTreeNode) {
            if (adapter instanceof IResourceTreeNode) {
                ((IResourceTreeNode)adapter).setViewer(this.repositoryTree);
            }
            ArrayList<Object> filtered = new ArrayList<Object>();
            Object[] children = adapter.getChildren(parentElement);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (this.filter == null || this.filter.accept(children[i])) {
                        if (children[i] instanceof IResourceTreeNode) {
                            ((IResourceTreeNode)children[i]).setViewer(this.repositoryTree);
                        }
                        filtered.add(children[i]);
                    }
                    ++i;
                }
            }
            return filtered.toArray();
        }
        return new Object[0];
    }
}

