/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.ui.history.data.SVNChangedPathData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffectedPathsNode {
    protected String name;
    protected String compressedName;
    protected List<AffectedPathsNode> children;
    protected AffectedPathsNode parent;
    protected ArrayList<SVNChangedPathData> data;
    protected SVNLogPath.ChangeType status;

    public AffectedPathsNode(String name, AffectedPathsNode parent, SVNLogPath.ChangeType status) {
        this.name = this.compressedName = name;
        this.parent = parent;
        this.data = new ArrayList();
        this.children = new ArrayList<AffectedPathsNode>();
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getCompressedName() {
        return this.compressedName;
    }

    public void addCompressedNameSegment(String compressedName) {
        this.compressedName = String.valueOf(this.compressedName) + "/" + compressedName;
    }

    public String toString() {
        return this.compressedName;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public AffectedPathsNode getParent() {
        return this.parent;
    }

    public List<AffectedPathsNode> getChildren() {
        return this.children;
    }

    public boolean addChild(AffectedPathsNode child) {
        if (this.children.contains(child)) {
            return false;
        }
        return this.children.add(child);
    }

    public boolean removeChild(AffectedPathsNode child) {
        if (this.children.contains(child)) {
            return this.children.remove(child);
        }
        return false;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof AffectedPathsNode) {
            AffectedPathsNode node2 = (AffectedPathsNode)arg0;
            if (this.parent == null) {
                return node2.parent == null;
            }
            if (this.parent.equals(node2.parent) && this.name.equals(node2.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 17;
        h += 31 * (this.parent != null ? this.parent.hashCode() : 0);
        return h += 31 * this.name.hashCode();
    }

    public SVNChangedPathData[] getData() {
        return this.data.toArray(new SVNChangedPathData[this.data.size()]);
    }

    protected List<SVNChangedPathData> getPathDataImpl(List<SVNChangedPathData> result) {
        result.addAll(this.data);
        for (AffectedPathsNode node : this.children) {
            node.getPathDataImpl(result);
        }
        return result;
    }

    public void addData(SVNChangedPathData data) {
        if (!this.data.contains(data)) {
            this.data.add(data);
        }
    }

    public SVNChangedPathData[] getPathData() {
        List<SVNChangedPathData> tmp = this.getPathDataImpl(new ArrayList<SVNChangedPathData>());
        return tmp.toArray(new SVNChangedPathData[tmp.size()]);
    }

    public void setParent(AffectedPathsNode parent) {
        this.parent = parent;
    }

    public void setChildren(List<AffectedPathsNode> children) {
        if (children != null) {
            this.children = children;
        } else {
            this.children.clear();
        }
    }

    public String getFullPath() {
        return this.parent != null ? String.valueOf(this.parent.getFullPath()) + "/" + this.compressedName : "";
    }

    public SVNLogPath.ChangeType getStatus() {
        return this.status;
    }

    public void setStatus(SVNLogPath.ChangeType status) {
        this.status = status;
    }
}

