/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.gtk;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;

public class ListDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;
    private List dragList;

    public ListDragSourceEffect(List list) {
        super(list);
        this.dragList = list;
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        int[] model;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (this.dragList.isListening(40) || this.dragList.isListening(42)) {
            return null;
        }
        int handle = this.dragList.handle;
        int selection = OS.gtk_tree_view_get_selection(handle);
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model = null);
        if (list == 0) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        int originalList = list;
        Display display = this.dragList.getDisplay();
        if (count == 1) {
            int path = OS.g_list_nth_data(list, 0);
            int icon = OS.gtk_tree_view_create_row_drag_icon(handle, path);
            this.dragSourceImage = Image.gtk_new(display, 1, icon, 0);
            OS.gtk_tree_path_free(path);
        } else {
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            int[] icons = new int[count];
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < count) {
                int path = OS.g_list_data(list);
                OS.gtk_tree_view_get_cell_area(handle, path, 0, rect);
                icons[i] = OS.gtk_tree_view_create_row_drag_icon(handle, path);
                if (OS.GTK3) {
                    switch (Cairo.cairo_surface_get_type(icons[i])) {
                        case 0: {
                            w[0] = Cairo.cairo_image_surface_get_width(icons[i]);
                            h[0] = Cairo.cairo_image_surface_get_height(icons[i]);
                            break;
                        }
                        case 3: {
                            w[0] = Cairo.cairo_xlib_surface_get_width(icons[i]);
                            h[0] = Cairo.cairo_xlib_surface_get_height(icons[i]);
                        }
                    }
                } else {
                    OS.gdk_pixmap_get_size(icons[i], w, h);
                }
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                list = OS.g_list_next(list);
                OS.gtk_tree_path_free(path);
                ++i;
            }
            if (OS.GTK3) {
                int cairo;
                int surface = Cairo.cairo_image_surface_create(0, width, height);
                if (surface == 0) {
                    SWT.error(2);
                }
                if ((cairo = Cairo.cairo_create(surface)) == 0) {
                    SWT.error(2);
                }
                Cairo.cairo_set_operator(cairo, 1);
                int i2 = 0;
                while (i2 < count) {
                    Cairo.cairo_set_source_surface(cairo, icons[i2], 2.0, yy[i2] - yy[0] + 2);
                    Cairo.cairo_rectangle(cairo, 0.0, yy[i2] - yy[0], width, hh[i2]);
                    Cairo.cairo_fill(cairo);
                    Cairo.cairo_surface_destroy(icons[i2]);
                    ++i2;
                }
                Cairo.cairo_destroy(cairo);
                this.dragSourceImage = Image.gtk_new(display, 1, surface, 0);
            } else {
                int source = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, -1);
                int gcSource = OS.gdk_gc_new(source);
                int mask = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, 1);
                int gcMask = OS.gdk_gc_new(mask);
                GdkColor color = new GdkColor();
                color.pixel = 0;
                OS.gdk_gc_set_foreground(gcMask, color);
                OS.gdk_draw_rectangle(mask, gcMask, 1, 0, 0, width, height);
                color.pixel = 1;
                OS.gdk_gc_set_foreground(gcMask, color);
                int i3 = 0;
                while (i3 < count) {
                    OS.gdk_draw_drawable(source, gcSource, icons[i3], 0, 0, 0, yy[i3] - yy[0], -1, -1);
                    OS.gdk_draw_rectangle(mask, gcMask, 1, 0, yy[i3] - yy[0], width, hh[i3]);
                    OS.g_object_unref(icons[i3]);
                    ++i3;
                }
                OS.g_object_unref(gcSource);
                OS.g_object_unref(gcMask);
                this.dragSourceImage = Image.gtk_new(display, 1, source, mask);
            }
        }
        OS.g_list_free(originalList);
        return this.dragSourceImage;
    }
}

