/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Suspension;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.def.Orientation;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.ListPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PossibleValuesListPresentationFactory;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class CheckBoxGroupPropertyEditorPresentation
extends ListPropertyEditorPresentation {
    @Text(value="<empty>")
    private static LocalizableText emptyIndicator;
    private final Orientation orientation;
    private ValueProperty memberProperty;
    private PossibleValuesService possibleValuesService;
    private ValueLabelService valueLabelService;
    private ValueImageService valueImageService;
    private LocalizationService localizationService;
    private Listener serviceListener;
    private Composite checkBoxesComposite;

    static {
        LocalizableText.init(CheckBoxGroupPropertyEditorPresentation.class);
    }

    public CheckBoxGroupPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite, Orientation orientation) {
        super(part, parent, composite);
        this.orientation = orientation;
    }

    @Override
    protected void createContents(Composite parent) {
        PropertyDef prop;
        final ElementList<?> list = this.property();
        ElementType memberType = list.definition().getType();
        SortedSet allMemberProperties = memberType.properties();
        if (allMemberProperties.size() == 1) {
            prop = (PropertyDef)allMemberProperties.first();
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        Composite mainComposite = this.createMainComposite(parent);
        mainComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(mainComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), this.orientation == Orientation.HORIZONTAL ? 0x1000000 : 128), this.orientation == Orientation.HORIZONTAL ? 0 : 4));
        this.checkBoxesComposite = new Composite(mainComposite, 0);
        this.checkBoxesComposite.setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
        RowLayout checkBoxesCompositeLayout = new RowLayout();
        checkBoxesCompositeLayout.type = this.orientation == Orientation.HORIZONTAL ? 256 : 512;
        checkBoxesCompositeLayout.wrap = false;
        checkBoxesCompositeLayout.marginTop = 0;
        checkBoxesCompositeLayout.marginBottom = 0;
        checkBoxesCompositeLayout.marginLeft = 0;
        checkBoxesCompositeLayout.marginRight = 0;
        checkBoxesCompositeLayout.spacing = this.orientation == Orientation.HORIZONTAL ? 10 : 5;
        this.checkBoxesComposite.setLayout((Layout)checkBoxesCompositeLayout);
        this.serviceListener = new Listener(){

            public void handle(Event event) {
                CheckBoxGroupPropertyEditorPresentation.this.refreshCheckBoxes();
            }
        };
        this.localizationService = (LocalizationService)this.part().definition().adapt(LocalizationService.class);
        this.possibleValuesService = (PossibleValuesService)list.service(PossibleValuesService.class);
        this.possibleValuesService.attach(this.serviceListener);
        this.valueLabelService = (ValueLabelService)this.memberProperty.service(ValueLabelService.class);
        this.valueLabelService.attach(this.serviceListener);
        this.valueImageService = (ValueImageService)this.memberProperty.service(ValueImageService.class);
        this.valueImageService.attach(this.serviceListener);
        FilteredListener<PropertyEvent> modelListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                if (event instanceof PropertyContentEvent || event instanceof PropertyValidationEvent) {
                    CheckBoxGroupPropertyEditorPresentation.this.refreshCheckBoxes();
                }
            }
        };
        list.attach((Listener)modelListener, this.memberProperty.name());
        this.addOnDisposeOperation(new Runnable((Listener)modelListener){
            private final /* synthetic */ Listener val$modelListener;
            {
                this.val$modelListener = listener;
            }

            @Override
            public void run() {
                CheckBoxGroupPropertyEditorPresentation.this.possibleValuesService.detach(CheckBoxGroupPropertyEditorPresentation.this.serviceListener);
                CheckBoxGroupPropertyEditorPresentation.this.valueLabelService.detach(CheckBoxGroupPropertyEditorPresentation.this.serviceListener);
                CheckBoxGroupPropertyEditorPresentation.this.valueImageService.detach(CheckBoxGroupPropertyEditorPresentation.this.serviceListener);
                if (!list.disposed()) {
                    list.detach(this.val$modelListener, CheckBoxGroupPropertyEditorPresentation.this.memberProperty.name());
                    for (Element element : list) {
                        ImageService imageService = (ImageService)element.service(ImageService.class);
                        if (imageService == null) continue;
                        imageService.detach(CheckBoxGroupPropertyEditorPresentation.this.serviceListener);
                    }
                }
            }
        });
        this.refreshCheckBoxes();
    }

    private void refreshCheckBoxes() {
        String value;
        Set possibleValues;
        ElementList<?> list = this.property();
        ArrayList<Button> checkboxes = new ArrayList<Button>();
        Control[] controlArray = this.checkBoxesComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            checkboxes.add((Button)control);
            ++n2;
        }
        HashMap<String, LinkedList<Element>> valueToElements = new HashMap<String, LinkedList<Element>>();
        for (Element element : list) {
            String value2 = this.readMemberProperty(element);
            LinkedList elements = (LinkedList)valueToElements.get(value2);
            if (elements == null) {
                elements = new LinkedList();
                valueToElements.put(value2, elements);
            }
            elements.add(element);
        }
        try {
            possibleValues = this.possibleValuesService.values();
        }
        catch (Exception e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            possibleValues = SetFactory.empty();
        }
        int position = 0;
        for (String value2 : possibleValues) {
            LinkedList elements = (LinkedList)valueToElements.get(value2);
            if (elements == null) {
                this.createOrRebaseCheckBox(checkboxes, position, value2, null);
                ++position;
                continue;
            }
            for (Element element : elements) {
                this.createOrRebaseCheckBox(checkboxes, position, value2, element);
                ++position;
            }
            valueToElements.remove(value2);
        }
        Iterator itr = valueToElements.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            value = (String)entry.getKey();
            if (value == null) continue;
            for (Element element : (LinkedList)entry.getValue()) {
                this.createOrRebaseCheckBox(checkboxes, position, value, element);
                ++position;
            }
            itr.remove();
        }
        for (Map.Entry entry : valueToElements.entrySet()) {
            value = (String)entry.getKey();
            for (Element element : (LinkedList)entry.getValue()) {
                this.createOrRebaseCheckBox(checkboxes, position, value, element);
                ++position;
            }
        }
        int i = position;
        int n3 = checkboxes.size();
        while (i < n3) {
            ((Button)checkboxes.get(i)).dispose();
            ++i;
        }
        this.layout();
    }

    private void createOrRebaseCheckBox(List<Button> checkboxes, int position, String value, Element element) {
        Button checkbox = position < checkboxes.size() ? checkboxes.get(position) : this.createCheckBox();
        this.rebaseCheckBox(checkbox, value, element);
    }

    private Button createCheckBox() {
        final Button checkbox = new Button(this.checkBoxesComposite, 32);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DelayedTasksExecutor.Task task = new DelayedTasksExecutor.Task(){

                    @Override
                    public void run() {
                        block12: {
                            if (checkbox.isDisposed()) {
                                return;
                            }
                            ElementList<?> list = CheckBoxGroupPropertyEditorPresentation.this.property();
                            boolean selection = checkbox.getSelection();
                            Element e = (Element)checkbox.getData("Element");
                            if (e == null && selection) {
                                Throwable throwable = null;
                                Object var5_6 = null;
                                try (Suspension s = list.suspend();){
                                    e = list.insert();
                                    CheckBoxGroupPropertyEditorPresentation.this.writeMemberProperty(e, (String)checkbox.getData("Value"));
                                    break block12;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            if (e != null && !selection) {
                                list.remove((Object)e);
                            }
                        }
                    }
                };
                DelayedTasksExecutor.schedule(task);
            }
        });
        this.addControl((Control)checkbox);
        this.decorator.addEditorControl((Control)checkbox);
        return checkbox;
    }

    private void rebaseCheckBox(Button checkbox, String value, Element element) {
        checkbox.setData("Value", (Object)value);
        checkbox.setData("Element", (Object)element);
        checkbox.setSelection(element != null);
        String text = null;
        if (value == null) {
            text = emptyIndicator.text();
        } else {
            try {
                text = this.valueLabelService.provide(value);
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            if (text == null) {
                text = value;
            } else if (!text.equals(value)) {
                text = this.localizationService.transform(text, CapitalizationType.FIRST_WORD_ONLY, false);
            }
        }
        checkbox.setText(text);
        ImageService elementImageService = (ImageService)checkbox.getData("ImageService");
        if (elementImageService != null) {
            elementImageService.detach(this.serviceListener);
        }
        if (element != null) {
            elementImageService = (ImageService)element.service(ImageService.class);
            checkbox.setData("ImageService", (Object)elementImageService);
            if (elementImageService != null) {
                elementImageService.attach(this.serviceListener);
            }
        }
        ImageData image = null;
        if (elementImageService != null) {
            image = elementImageService.image();
        } else {
            try {
                image = this.valueImageService.provide(value);
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        if (element == null) {
            checkbox.setImage(this.resources().image(image));
        } else {
            checkbox.setImage(this.resources().image(image, element.property(this.memberProperty).validation().severity()));
        }
    }

    private String readMemberProperty(Element element) {
        return element.property(this.memberProperty).text();
    }

    private void writeMemberProperty(Element element, String text) {
        element.property(this.memberProperty).write((Object)text, true);
    }

    @Override
    protected void handleFocusReceivedEvent() {
        Control[] controlArray = this.checkBoxesComposite.getChildren();
        if (controlArray.length != 0) {
            Control control = controlArray[0];
            control.setFocus();
        }
    }

    public static final class HorizontalFactory
    extends PossibleValuesListPresentationFactory {
        @Override
        protected boolean check(PropertyEditorPart part) {
            String style = (String)part.definition().getStyle().content();
            if (style != null && (style.equals("Sapphire.PropertyEditor.CheckBoxGroup") || style.equals("Sapphire.PropertyEditor.CheckBoxGroup.Horizontal"))) {
                return super.check(part);
            }
            return false;
        }

        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            if (this.check(part)) {
                return new CheckBoxGroupPropertyEditorPresentation(part, parent, composite, Orientation.HORIZONTAL);
            }
            return null;
        }
    }

    public static final class VerticalFactory
    extends PossibleValuesListPresentationFactory {
        @Override
        protected boolean check(PropertyEditorPart part) {
            String style = (String)part.definition().getStyle().content();
            if (style != null && style.equals("Sapphire.PropertyEditor.CheckBoxGroup.Vertical")) {
                return super.check(part);
            }
            return false;
        }

        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            if (this.check(part)) {
                return new CheckBoxGroupPropertyEditorPresentation(part, parent, composite, Orientation.VERTICAL);
            }
            return null;
        }
    }
}

