/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Composite;

public abstract class ListPropertyEditorPresentation
extends PropertyEditorPresentation {
    private Listener listElementListener = new FilteredListener<PropertyContentEvent>(){

        protected void handleTypedEvent(PropertyContentEvent event) {
            ListPropertyEditorPresentation.this.handleChildPropertyEvent(event);
        }
    };

    public ListPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
        this.attachListElementListener();
        this.addOnDisposeOperation(new Runnable(){

            @Override
            public void run() {
                ElementList<?> property = ListPropertyEditorPresentation.this.property();
                if (!property.disposed()) {
                    List<ModelPath> childPropertyPaths = ListPropertyEditorPresentation.this.part().getChildProperties();
                    for (Element entry : property) {
                        for (ModelPath childPropertyPath : childPropertyPaths) {
                            entry.detach(ListPropertyEditorPresentation.this.listElementListener, childPropertyPath);
                        }
                    }
                }
            }
        });
    }

    public ElementList<?> property() {
        return (ElementList)super.property();
    }

    public ElementList<?> list() {
        return this.property();
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.attachListElementListener();
    }

    protected void handleChildPropertyEvent(PropertyContentEvent event) {
    }

    private void attachListElementListener() {
        List<ModelPath> childPropertyPaths = this.part().getChildProperties();
        for (Element entry : this.property()) {
            for (ModelPath childPropertyPath : childPropertyPaths) {
                entry.attach(this.listElementListener, childPropertyPath);
            }
        }
    }
}

