/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.diagram.editor.ContainerShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeLayoutDef;
import org.eclipse.sapphire.ui.swt.gef.model.ContainerShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ContainerShapePresentation
extends ShapePresentation {
    private List<ShapePresentation> children = new ArrayList<ShapePresentation>();
    private Listener partVisibilityListener;

    public ContainerShapePresentation(DiagramPresentation parent, ContainerShapePart containerShapePart, DiagramResourceCache resourceCache) {
        super(parent, (ShapePart)containerShapePart, resourceCache);
        ShapePresentation childPresentation = null;
        for (ShapePart shapePart : containerShapePart.getChildren()) {
            if (!this.canAddShapePart(shapePart)) continue;
            childPresentation = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, shapePart, resourceCache);
            this.children.add(childPresentation);
        }
    }

    public void init(final ContainerShapeModel model) {
        this.partVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                ShapePart shapePart = (ShapePart)event.part();
                model.handleVisibilityChange(shapePart);
            }
        };
        this.part().attach(this.partVisibilityListener);
    }

    protected boolean canAddShapePart(ShapePart shapePart) {
        if (shapePart instanceof ContainerShapePart) {
            return shapePart.visible();
        }
        return true;
    }

    public List<ShapePresentation> getChildren() {
        return this.children;
    }

    public ContainerShapePart part() {
        return (ContainerShapePart)super.part();
    }

    public ShapeLayoutDef getLayout() {
        return this.part().getLayout();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.part().detach(this.partVisibilityListener);
        for (ShapePresentation shapePresentation : this.getChildren()) {
            shapePresentation.dispose();
        }
    }

    public void refreshChildren() {
        ArrayList<ShapePresentation> refreshedChildren = new ArrayList<ShapePresentation>();
        ContainerShapePart containerShapePart = this.part();
        for (ShapePart shapePart : containerShapePart.getChildren()) {
            if (!this.canAddShapePart(shapePart)) continue;
            ShapePresentation childPresentation = this.getChildShapePresentation(shapePart);
            if (childPresentation == null) {
                childPresentation = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, shapePart, this.getResourceCache());
            }
            refreshedChildren.add(childPresentation);
        }
        this.children = refreshedChildren;
    }

    private ShapePresentation getChildShapePresentation(ShapePart shapePart) {
        for (ShapePresentation presentation : this.getChildren()) {
            if (presentation.part() != shapePart) continue;
            return presentation;
        }
        return null;
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        for (ShapePresentation shapePresentation : this.getChildren()) {
            shapePresentation.refreshVisuals();
        }
    }

    public int getChildFigureIndex(ShapePresentation childShapePresentation) {
        int shapeIndex = this.getChildren().indexOf((Object)childShapePresentation);
        if (shapeIndex == -1) {
            return -1;
        }
        int figureIndex = 0;
        int i = 0;
        while (i < shapeIndex) {
            if (this.getChildren().get(i).getFigure() != null) {
                ++figureIndex;
            }
            ++i;
        }
        return figureIndex;
    }
}

