/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.interactive.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.pmf.pim.interactive.ClassHandlerAction;
import org.eclipse.pmf.pim.interactive.ConditionTrigger;
import org.eclipse.pmf.pim.interactive.DataPredicate;
import org.eclipse.pmf.pim.interactive.EventTrigger;
import org.eclipse.pmf.pim.interactive.ExpressionCondition;
import org.eclipse.pmf.pim.interactive.InteractiveFactory;
import org.eclipse.pmf.pim.interactive.InteractivePackage;
import org.eclipse.pmf.pim.interactive.Operator;
import org.eclipse.pmf.pim.interactive.PredicateTerm;
import org.eclipse.pmf.pim.interactive.SetAction;
import org.eclipse.pmf.pim.interactive.Trigger;
import org.eclipse.pmf.pim.interactive.TriggerAction;
import org.eclipse.pmf.pim.interactive.UIPredicate;
import org.eclipse.pmf.pim.interactive.impl.ClassHandlerActionImpl;
import org.eclipse.pmf.pim.interactive.impl.ConditionTriggerImpl;
import org.eclipse.pmf.pim.interactive.impl.DataPredicateImpl;
import org.eclipse.pmf.pim.interactive.impl.EventTriggerImpl;
import org.eclipse.pmf.pim.interactive.impl.ExpressionConditionImpl;
import org.eclipse.pmf.pim.interactive.impl.PredicateTermImpl;
import org.eclipse.pmf.pim.interactive.impl.SetActionImpl;
import org.eclipse.pmf.pim.interactive.impl.TriggerActionImpl;
import org.eclipse.pmf.pim.interactive.impl.TriggerImpl;
import org.eclipse.pmf.pim.interactive.impl.UIPredicateImpl;

public class InteractiveFactoryImpl
extends EFactoryImpl
implements InteractiveFactory {
    public static InteractiveFactory init() {
        try {
            InteractiveFactory theInteractiveFactory = (InteractiveFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/pmf/interactive");
            if (theInteractiveFactory != null) {
                return theInteractiveFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InteractiveFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createTriggerAction();
            }
            case 3: {
                return this.createDataPredicate();
            }
            case 4: {
                return this.createUIPredicate();
            }
            case 5: {
                return this.createExpressionCondition();
            }
            case 6: {
                return this.createSetAction();
            }
            case 7: {
                return this.createTrigger();
            }
            case 8: {
                return this.createPredicateTerm();
            }
            case 10: {
                return this.createConditionTrigger();
            }
            case 11: {
                return this.createEventTrigger();
            }
            case 12: {
                return this.createClassHandlerAction();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.createOperatorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.convertOperatorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public TriggerAction createTriggerAction() {
        TriggerActionImpl triggerAction = new TriggerActionImpl();
        return triggerAction;
    }

    @Override
    public DataPredicate createDataPredicate() {
        DataPredicateImpl dataPredicate = new DataPredicateImpl();
        return dataPredicate;
    }

    @Override
    public UIPredicate createUIPredicate() {
        UIPredicateImpl uiPredicate = new UIPredicateImpl();
        return uiPredicate;
    }

    @Override
    public ExpressionCondition createExpressionCondition() {
        ExpressionConditionImpl expressionCondition = new ExpressionConditionImpl();
        return expressionCondition;
    }

    @Override
    public SetAction createSetAction() {
        SetActionImpl setAction = new SetActionImpl();
        return setAction;
    }

    @Override
    public Trigger createTrigger() {
        TriggerImpl trigger = new TriggerImpl();
        return trigger;
    }

    @Override
    public PredicateTerm createPredicateTerm() {
        PredicateTermImpl predicateTerm = new PredicateTermImpl();
        return predicateTerm;
    }

    @Override
    public ConditionTrigger createConditionTrigger() {
        ConditionTriggerImpl conditionTrigger = new ConditionTriggerImpl();
        return conditionTrigger;
    }

    @Override
    public EventTrigger createEventTrigger() {
        EventTriggerImpl eventTrigger = new EventTriggerImpl();
        return eventTrigger;
    }

    @Override
    public ClassHandlerAction createClassHandlerAction() {
        ClassHandlerActionImpl classHandlerAction = new ClassHandlerActionImpl();
        return classHandlerAction;
    }

    public Operator createOperatorFromString(EDataType eDataType, String initialValue) {
        Operator result = Operator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public InteractivePackage getInteractivePackage() {
        return (InteractivePackage)this.getEPackage();
    }

    @Deprecated
    public static InteractivePackage getPackage() {
        return InteractivePackage.eINSTANCE;
    }
}

