/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.php.composer.api.packages.AsyncDownloadClient;
import org.eclipse.php.composer.api.packages.DownloadListenerAdapater;
import org.eclipse.php.composer.api.packages.PackageHelper;
import org.eclipse.php.composer.api.packages.PackageSearchListenerInterface;

public class AsyncPackageSearch
extends AsyncDownloadClient {
    private int pageLimit = 3;
    protected List<PackageSearchListenerInterface> listeners = new ArrayList<PackageSearchListenerInterface>();
    private Map<String, Integer> counters = new HashMap<String, Integer>();
    private Map<String, Boolean> aborts = new HashMap<String, Boolean>();
    private Log log = LogFactory.getLog(AsyncPackageSearch.class);

    public AsyncPackageSearch() {
        this.init();
    }

    public AsyncPackageSearch(String baseUrl) {
        super(baseUrl, true);
        this.init();
    }

    private void init() {
        this.downloader.addDownloadListener(new DownloadListenerAdapater(){

            private String getQuery(String url) {
                try {
                    return URLDecoder.decode(url.replaceFirst(".+q=([^?&]+).*", "$1"), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    AsyncPackageSearch.this.log.error((Object)e);
                    return null;
                }
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void dataReceived(InputStream content, String url) {
                block6: {
                    try {
                        query = this.getQuery(url);
                        if (AsyncPackageSearch.access$1(AsyncPackageSearch.this, query)) {
                            return;
                        }
                        result = PackageHelper.getSearchResult(content);
                        counter = AsyncPackageSearch.access$2(AsyncPackageSearch.this, query);
                        if (result != null && result.results != null) {
                            for (PackageSearchListenerInterface listener : AsyncPackageSearch.this.listeners) {
                                listener.packagesFound(result.results, query, result);
                            }
                        }
                        if (result == null || result.next == null || result.next.length() <= 0 || counter >= AsyncPackageSearch.access$3(AsyncPackageSearch.this)) break block6;
                        AsyncPackageSearch.this.downloader.setUrl(result.next);
                        AsyncPackageSearch.this.downloader.download();
                        AsyncPackageSearch.access$4(AsyncPackageSearch.this).put(query, counter + 1);
                        break block6;
                    }
                    catch (Exception e) {
                        ** for (listener : AsyncPackageSearch.this.listeners)
                    }
lbl-1000:
                    // 1 sources

                    {
                        listener.errorOccured(e);
                        continue;
                    }
                }
            }

            @Override
            public void aborted(String url) {
                AsyncPackageSearch.this.aborts.put(this.getQuery(url), true);
                for (PackageSearchListenerInterface listener : AsyncPackageSearch.this.listeners) {
                    listener.aborted(url);
                }
            }
        });
    }

    public void addPackageSearchListener(PackageSearchListenerInterface listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePackageSearchListener(PackageSearchListenerInterface listener) {
        this.listeners.remove(listener);
    }

    private int getCounter(String query) {
        if (!this.counters.containsKey(query)) {
            this.counters.put(query, 1);
        }
        return this.counters.get(query);
    }

    private boolean isAborted(String query) {
        if (!this.aborts.containsKey(query)) {
            this.aborts.put(query, false);
        }
        return this.aborts.get(query);
    }

    public int search(String query) {
        this.counters.put(query, 1);
        this.aborts.put(query, false);
        this.downloader.setUrl(this.createUrl(query));
        return this.downloader.download();
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    static /* synthetic */ boolean access$1(AsyncPackageSearch asyncPackageSearch, String string) {
        return asyncPackageSearch.isAborted(string);
    }

    static /* synthetic */ int access$2(AsyncPackageSearch asyncPackageSearch, String string) {
        return asyncPackageSearch.getCounter(string);
    }

    static /* synthetic */ int access$3(AsyncPackageSearch asyncPackageSearch) {
        return asyncPackageSearch.pageLimit;
    }

    static /* synthetic */ Map access$4(AsyncPackageSearch asyncPackageSearch) {
        return asyncPackageSearch.counters;
    }
}

