/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.constraints;

import java.lang.ref.WeakReference;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class HasStereotypeConstraint
extends AbstractConstraint {
    protected String stereotypeName;
    @Deprecated
    protected Element umlElement;
    private WeakReference<Element> contextElement;

    public boolean match(Object selection) {
        Stereotype stereotype;
        Element element = UMLUtil.resolveUMLElement((Object)selection);
        if (element == null) {
            return false;
        }
        this.contextElement = new WeakReference<Element>(element);
        if (((Object)((Object)this)).getClass() != HasStereotypeConstraint.class) {
            this.umlElement = element;
        }
        return (stereotype = UMLUtil.getAppliedStereotype((Element)element, (String)this.stereotypeName, (boolean)false)) != null;
    }

    public void setDescriptor(SimpleConstraint descriptor) {
        this.stereotypeName = this.getValue("stereotypeName");
    }

    public boolean overrides(Constraint constraint) {
        boolean overrides = false;
        if (constraint instanceof HasStereotypeConstraint) {
            Element element;
            HasStereotypeConstraint stereotypeConstraint = (HasStereotypeConstraint)constraint;
            if (!this.stereotypeName.equals(stereotypeConstraint.stereotypeName) && (element = (Element)this.contextElement.get()) != null) {
                Stereotype thisStereotype = element.getApplicableStereotype(this.stereotypeName);
                Stereotype otherStereotype = UMLUtil.findStereotype((Element)element, (String)stereotypeConstraint.stereotypeName);
                if (UMLUtil.getAllSuperStereotypes((Stereotype)thisStereotype).contains(otherStereotype)) {
                    overrides = true;
                }
            }
        }
        return overrides || super.overrides(constraint);
    }

    public String toString() {
        return String.format("HasStereotype %s (%s)", this.stereotypeName, this.getDisplayUnit().getElementMultiplicity() == 1 ? "Single" : "Multiple");
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof HasStereotypeConstraint)) {
            return false;
        }
        HasStereotypeConstraint other = (HasStereotypeConstraint)constraint;
        return !(this.stereotypeName == null ? other.stereotypeName != null : !this.stereotypeName.equals(other.stereotypeName));
    }
}

