/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.providers;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractLineStyleToggleState
extends ToggleState
implements ISelectionListener {
    private String parameter;
    private ISelectionService serv = null;

    public AbstractLineStyleToggleState(String parameter) {
        this.parameter = parameter;
        this.setValue(false);
        this.addSelectionListener();
        if (this.serv != null) {
            this.updateStatus(this.serv.getSelection());
        }
    }

    protected void addSelectionListener() {
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench;
        if (this.serv == null && (workbench = PlatformUI.getWorkbench()) != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            this.serv = workbenchWindow.getSelectionService();
            if (this.serv != null) {
                this.serv.addSelectionListener((ISelectionListener)this);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateStatus(selection);
    }

    protected void updateStatus(ISelection selection) {
        Object firstSelectedElement;
        boolean newValue = false;
        if (selection instanceof IStructuredSelection && (firstSelectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IGraphicalEditPart) {
            ENamedElement element = PackageUtil.getElement((String)"notation.RoutingStyle.routing");
            Object value = null;
            if (element instanceof EStructuralFeature) {
                value = ((IGraphicalEditPart)firstSelectedElement).getStructuralFeatureValue((EStructuralFeature)element);
                if (this.parameter.equals("oblique")) {
                    if (Routing.MANUAL_LITERAL.equals(value)) {
                        newValue = true;
                    }
                } else if (this.parameter.equals("rectilinear")) {
                    if (Routing.RECTILINEAR_LITERAL.equals(value)) {
                        newValue = true;
                    }
                } else if (this.parameter.equals("tree") && Routing.TREE_LITERAL.equals(value)) {
                    newValue = true;
                }
            }
        }
        this.setValue(newValue);
    }

    public void dispose() {
        if (this.serv != null) {
            this.serv.removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
    }
}

