/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFListener;
import org.eclipse.papyrus.infra.sync.SyncItem;

public abstract class EMFDispatchManager<D extends EMFDispatch> {
    private final EMFListener listener;

    protected EMFDispatchManager(EMFListener listener) {
        this.listener = listener;
    }

    public static <D extends EMFDispatch> EMFDispatchManager<D> createMultiple(EMFListener listener) {
        return new Multi(listener);
    }

    public static <D extends EMFDispatch> EMFDispatchManager<D> createSingle(EMFListener listener) {
        return new Single(listener);
    }

    public void add(SyncItem<?, ?> syncItem, D dispatch) {
        this.put(syncItem, dispatch);
        this.listener.add((EMFDispatch)dispatch);
    }

    public D getDispatcher(SyncItem<?, ?> syncItem, Object feature) {
        EMFDispatch result = null;
        for (EMFDispatch next : this.iterate(syncItem)) {
            EStructuralFeature nextFeature = next.getFeature();
            if (nextFeature != feature && nextFeature != null) continue;
            result = next;
            break;
        }
        return (D)result;
    }

    protected abstract void put(SyncItem<?, ?> var1, D var2);

    protected abstract boolean isActive(SyncItem<?, ?> var1);

    protected abstract Iterable<SyncItem<?, ?>> getActive();

    protected abstract Iterable<D> iterate(SyncItem<?, ?> var1);

    protected abstract Iterable<Map.Entry<SyncItem<?, ?>, D>> activeEntries();

    protected abstract void clear();

    public void remove(SyncItem<?, ?> syncItem) {
        if (this.isActive(syncItem)) {
            Iterator<D> iter = this.iterate(syncItem).iterator();
            while (iter.hasNext()) {
                this.listener.remove((EMFDispatch)iter.next());
                iter.remove();
            }
        }
    }

    public void remove(EMFDispatch dispatch) {
        Iterator<Map.Entry<SyncItem<?, ?>, D>> iter = this.activeEntries().iterator();
        while (iter.hasNext()) {
            Map.Entry<SyncItem<?, ?>, D> next = iter.next();
            if (next.getValue() != dispatch) continue;
            this.listener.remove(dispatch);
            iter.remove();
        }
    }

    public void removeAll() {
        for (SyncItem<?, ?> syncItem : this.getActive()) {
            for (EMFDispatch next : this.iterate(syncItem)) {
                this.listener.remove(next);
            }
        }
        this.clear();
    }

    private static final class Multi<D extends EMFDispatch>
    extends EMFDispatchManager<D> {
        private final Multimap<SyncItem<?, ?>, D> active = ArrayListMultimap.create();

        Multi(EMFListener listener) {
            super(listener);
        }

        @Override
        protected void put(SyncItem<?, ?> syncItem, D dispatch) {
            this.active.put(syncItem, dispatch);
        }

        @Override
        protected boolean isActive(SyncItem<?, ?> syncItem) {
            return this.active.containsKey(syncItem);
        }

        @Override
        protected Iterable<SyncItem<?, ?>> getActive() {
            return this.active.keySet();
        }

        @Override
        protected Iterable<D> iterate(SyncItem<?, ?> syncItem) {
            return this.active.get(syncItem);
        }

        @Override
        protected Iterable<Map.Entry<SyncItem<?, ?>, D>> activeEntries() {
            return this.active.entries();
        }

        @Override
        protected void clear() {
            this.active.clear();
        }
    }

    private static final class Single<D extends EMFDispatch>
    extends EMFDispatchManager<D> {
        private final EMap<SyncItem<?, ?>, D> active = new BasicEMap<SyncItem<?, ?>, D>(){
            private static final long serialVersionUID = 1L;

            protected void didRemove(BasicEMap.Entry<SyncItem<?, ?>, D> entry) {
                mapping.clear();
            }

            protected void didClear(BasicEList<BasicEMap.Entry<SyncItem<?, ?>, D>>[] oldEntryData) {
                mapping.clear();
            }
        };
        private final SingletonMapping mapping = new SingletonMapping();

        Single(EMFListener listener) {
            super(listener);
        }

        @Override
        protected void put(SyncItem<?, ?> syncItem, D dispatch) {
            this.active.put(syncItem, dispatch);
        }

        @Override
        protected boolean isActive(SyncItem<?, ?> syncItem) {
            return this.active.containsKey(syncItem);
        }

        @Override
        protected Iterable<SyncItem<?, ?>> getActive() {
            return this.active.keySet();
        }

        @Override
        protected Iterable<D> iterate(SyncItem<?, ?> syncItem) {
            return this.mapping.prime(syncItem);
        }

        @Override
        protected Iterable<Map.Entry<SyncItem<?, ?>, D>> activeEntries() {
            return this.active.entrySet();
        }

        @Override
        protected void clear() {
            this.active.clear();
        }

        private final class SingletonMapping
        implements Iterable<D> {
            private SyncItem<?, ?> key;
            private D value;
            private final Iterator<D> iterator = new Iterator<D>(){

                @Override
                public boolean hasNext() {
                    return SingletonMapping.this.value != null;
                }

                @Override
                public D next() {
                    if (SingletonMapping.this.value == null) {
                        throw new NoSuchElementException();
                    }
                    EMFDispatch result = SingletonMapping.this.value;
                    SingletonMapping.this.value = null;
                    return result;
                }

                @Override
                public void remove() {
                    Single.this.active.remove((Object)SingletonMapping.this.key);
                }
            };

            private SingletonMapping() {
            }

            @Override
            public Iterator<D> iterator() {
                return this.iterator;
            }

            Iterable<D> prime(SyncItem<?, ?> key) {
                this.key = key;
                this.value = (EMFDispatch)Single.this.active.get(key);
                return this;
            }

            void clear() {
                this.key = null;
                this.value = null;
            }
        }
    }
}

