/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedAdapter;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class AspectUnspecifiedTypeCreationTool
extends UnspecifiedTypeCreationTool {
    protected List<IElementType> elementTypes;
    static final int MODIFIER_NO_SNAPPING = "macosx".equals(Platform.getOS()) ? 262144 : 65536;
    public static final String INITIAL_MOUSE_LOCATION_FOR_CREATION = "initialMouseLocationForCreation";

    public AspectUnspecifiedTypeCreationTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.elementTypes = elementTypes;
    }

    protected void performCreation(int button) {
        this.antiScroll = true;
        EditPartViewer currentViewer = this.getCurrentViewer();
        Command command = this.getCurrentCommand();
        if (command != null) {
            Command completeCommand = this.getCompleteCommand(command);
            this.setCurrentCommand(completeCommand);
            this.executeCurrentCommand();
        }
        LinkedList selectableEditParts = new LinkedList(DiagramCommandStack.getReturnValues((Command)command));
        Iterator editPartsIterator = selectableEditParts.iterator();
        while (editPartsIterator.hasNext()) {
            EditPart editPart;
            Object editPartObject = editPartsIterator.next();
            if (!(editPartObject instanceof IAdaptable) || (editPart = (EditPart)currentViewer.getEditPartRegistry().get(((IAdaptable)editPartObject).getAdapter(View.class))) != null && editPart.isSelectable()) continue;
            editPartsIterator.remove();
        }
        this.selectAddedObject(currentViewer, selectableEditParts);
        this.antiScroll = false;
    }

    protected Command getCompleteCommand(Command createCommand) {
        CompoundCommand compositeCmd = new CompoundCommand("Create Element");
        compositeCmd.add(createCommand);
        CreateUnspecifiedAdapter viewAdapter = new CreateUnspecifiedAdapter();
        viewAdapter.add(this.getCreateRequest());
        return compositeCmd;
    }

    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    protected Request createTargetRequest() {
        CreateAspectUnspecifiedTypeRequest request = new CreateAspectUnspecifiedTypeRequest(this.getElementTypes(), this.getPreferencesHint());
        return request;
    }

    protected void createShapeAt(Point point) {
        this.setTargetEditPart(this.getCurrentViewer().getRootEditPart().getContents());
        this.getCreateRequest().setLocation(point);
        this.setCurrentCommand(this.getCommand());
        this.performCreation(0);
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        CreateRequest createRequest = this.getCreateRequest();
        Map params = createRequest.getExtendedData();
        params.put(INITIAL_MOUSE_LOCATION_FOR_CREATION, this.getLocation());
        if (!this.isInState(4) && !this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING) && this.getTargetEditPart() != null) {
            SnapToHelper helper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class);
            Point loq = this.getLocation();
            Rectangle bounds = new Rectangle(loq, loq);
            createRequest.setSnapToEnabled(!this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING));
            createRequest.setLocation(bounds.getLocation());
            if (helper != null && createRequest.isSnapToEnabled()) {
                PrecisionRectangle baseRect = new PrecisionRectangle(bounds);
                PrecisionRectangle result = baseRect.getPreciseCopy();
                helper.snapRectangle((Request)createRequest, 9, baseRect, result);
                createRequest.setLocation(result.getLocation());
            }
            this.enforceConstraintsForSizeOnDropCreate(createRequest);
        }
    }

    public class CreateAspectUnspecifiedTypeRequest
    extends CreateUnspecifiedTypeRequest {
        public CreateAspectUnspecifiedTypeRequest(List<IElementType> elementTypes, PreferencesHint preferencesHint) {
            super(elementTypes, preferencesHint);
        }

        protected void createRequests() {
            for (IElementType elementType : this.getElementTypes()) {
                CreateViewRequest.ViewDescriptor viewDescriptor;
                CreateViewRequest request = null;
                if (elementType instanceof INotationType) {
                    viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, ((INotationType)elementType).getSemanticHint(), this.getPreferencesHint());
                    request = new CreateViewRequest(viewDescriptor);
                } else if (elementType instanceof IHintedType) {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getGraphicalHint((IHintedType)elementType), this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                } else {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                }
                if (request instanceof CreateRequest) {
                    ((CreateRequest)request).setSnapToEnabled(!AspectUnspecifiedTypeCreationTool.this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING));
                }
                request.setType(this.getType());
                this.requests.put(elementType, request);
            }
        }

        protected String getGraphicalHint(IHintedType elementType) {
            String hint = elementType.getSemanticHint();
            return hint;
        }
    }
}

