/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.ConstrainedProperty;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class StereotypeProperty
extends ConstrainedProperty {
    public StereotypeProperty(@NonNull Property property) {
        super(property);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        IdResolver idResolver = executor.getIdResolver();
        EObject eObject = StereotypeProperty.asNavigableObject(sourceValue, (Object)this.property, executor);
        Object boxedValue = null;
        if (eObject instanceof ElementExtension) {
            ElementExtension elementExtension = (ElementExtension)eObject;
            String propertyName = this.property.getName();
            Property extensionProperty = NameUtil.getNameable(elementExtension.getOwnedProperties(), propertyName);
            if (extensionProperty == null) {
                EClass eClass;
                EStructuralFeature eStructuralFeature;
                EObject umlStereotypeApplication;
                boolean gotIt = false;
                Object defaultValue = null;
                LanguageExpression defaultExpression = null;
                if (elementExtension.isIsApplied() && (umlStereotypeApplication = elementExtension.getESObject()) != null && (eStructuralFeature = (EStructuralFeature)NameUtil.getENamedElement((eClass = umlStereotypeApplication.eClass()).getEAllStructuralFeatures(), propertyName)) != null) {
                    defaultValue = idResolver.boxedValueOf(umlStereotypeApplication.eGet(eStructuralFeature));
                    gotIt = true;
                }
                if (!gotIt && (elementExtension.isIsApplied() || elementExtension.isIsRequired())) {
                    Property theProperty = NameUtil.getNameable(elementExtension.getStereotype().getOwnedProperties(), propertyName);
                    defaultValue = theProperty != null ? theProperty.getDefaultValue() : null;
                    defaultExpression = theProperty != null ? theProperty.getOwnedExpression() : null;
                    gotIt = true;
                }
                extensionProperty = PivotFactory.eINSTANCE.createProperty();
                extensionProperty.setName(propertyName);
                extensionProperty.setIsRequired(this.property.isIsRequired());
                extensionProperty.setIsStatic(this.property.isIsStatic());
                extensionProperty.setType(this.property.getType());
                extensionProperty.setDefaultValue(defaultValue);
                extensionProperty.setOwnedExpression(defaultExpression);
                elementExtension.getOwnedProperties().add(extensionProperty);
            }
            Object defaultValue = extensionProperty.getDefaultValue();
            LanguageExpression defaultExpression = extensionProperty.getOwnedExpression();
            if (!extensionProperty.isIsDerived()) {
                return defaultValue;
            }
            if (defaultExpression == null) return boxedValue;
            String body = defaultExpression.getBody();
            if (body == null) return boxedValue;
            try {
                MetamodelManager metamodelManager = executor.getMetamodelManager();
                ExpressionInOCL expr = metamodelManager.parseSpecification(defaultExpression);
                OCLExpression bodyExpression = expr.getOwnedBody();
                if (bodyExpression == null) return boxedValue;
                return executor.evaluate(bodyExpression);
            }
            catch (ParserException e) {
                throw new InvalidValueException(e, "Bad defaultExpression for '{0}'", this.property);
            }
        }
        EClass eClass = eObject.eClass();
        EStructuralFeature eFeature = (EStructuralFeature)NameUtil.getENamedElement(eClass.getEAllStructuralFeatures(), this.property.getName());
        if (eFeature == null) return boxedValue;
        Object value = eObject.eGet(eFeature);
        if (value == null) return null;
        Object object = idResolver.boxedValueOf(value, (ETypedElement)eFeature, returnTypeId);
        return object;
    }
}

