/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.samples;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.objectteams.otdt.internal.samples.Messages;
import org.eclipse.objectteams.otdt.internal.samples.PDEImages;
import org.eclipse.objectteams.otdt.internal.samples.SampleWizard;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectionPage
extends WizardPage {
    private SelectionPart part;
    private Text desc;
    private SampleWizard wizard;
    private PDEImages pdeImages;

    public SelectionPage(SampleWizard wizard) {
        super("selection");
        this.wizard = wizard;
        this.setTitle(Messages.SelectionPage_title);
        this.setDescription(Messages.SelectionPage_desc);
        this.part = new SelectionPart();
        this.pdeImages = PDEImages.connect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.part.setMinimumSize(300, 300);
        this.part.createControl(container, 2816, 2, null);
        this.part.getTableViewer().setContentProvider((IContentProvider)new SampleProvider());
        this.part.getTableViewer().setLabelProvider((IBaseLabelProvider)new SampleLabelProvider());
        this.desc = new Text(container, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 64;
        this.desc.setLayoutData((Object)gd);
        this.part.getTableViewer().setInput((Object)this);
        this.updateSelection(null);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.selection_page");
    }

    public void dispose() {
        this.pdeImages.disconnect((Object)this);
        super.dispose();
    }

    private void doMoreInfo() {
        if (this.wizard.getSelection() != null) {
            IConfigurationElement[] desc = this.wizard.getSelection().getChildren("description");
            String helpHref = desc[0].getAttribute("helpHref");
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpHref);
        }
    }

    private void updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            this.desc.setText("");
            this.part.setButtonEnabled(0, false);
            this.setPageComplete(false);
        } else {
            IConfigurationElement sample = (IConfigurationElement)selection.getFirstElement();
            String text = "";
            String helpHref = null;
            IConfigurationElement[] sampleDesc = sample.getChildren("description");
            if (sampleDesc.length == 1) {
                text = sampleDesc[0].getValue();
                helpHref = sampleDesc[0].getAttribute("helpHref");
            }
            this.desc.setText(text);
            this.part.setButtonEnabled(0, helpHref != null);
            this.wizard.setSelection(sample);
            this.wizard.updateEntries();
            this.setPageComplete(true);
        }
    }

    class SampleLabelProvider
    extends LabelProvider {
        private Image image;

        public SampleLabelProvider() {
            this.image = SelectionPage.this.pdeImages.get(PDEImages.DESC_NEWEXP_TOOL);
        }

        public String getText(Object obj) {
            IConfigurationElement sample = (IConfigurationElement)obj;
            return sample.getAttribute("name");
        }

        public Image getImage(Object obj) {
            return this.image;
        }
    }

    class SampleProvider
    implements IStructuredContentProvider {
        SampleProvider() {
        }

        public Object[] getElements(Object input) {
            return SelectionPage.this.wizard.getSamples();
        }
    }

    class SelectionPart
    extends TablePart {
        public SelectionPart() {
            super(new String[]{"More Info"});
        }

        protected void buttonSelected(Button button, int index) {
            if (index == 0) {
                SelectionPage.this.doMoreInfo();
            }
        }

        protected void selectionChanged(IStructuredSelection selection) {
            SelectionPage.this.updateSelection(selection);
        }

        protected void handleDoubleClick(IStructuredSelection selection) {
        }

        public void setMinimumSize(int width, int height) {
            super.setMinimumSize(width, height);
        }

        public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
            super.createControl(parent, style, span, toolkit);
        }

        public TableViewer getTableViewer() {
            return super.getTableViewer();
        }

        public void setButtonEnabled(int index, boolean enabled) {
            super.setButtonEnabled(index, enabled);
        }
    }
}

