/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.JavaCallbackListener;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RichTextEditor
extends Composite {
    private Double CKEDITOR_ALT;
    private Double CKEDITOR_CTRL;
    private Double CKEDITOR_SHIFT;
    private boolean editorLoaded = false;
    private String initialValue = null;
    private boolean initialSetFocus = false;
    protected Rectangle resizedBounds = null;
    private final Browser browser;
    private final List<BrowserFunction> browserFunctions = new ArrayList<BrowserFunction>();
    private final ListenerList modifyListener = new ListenerList(1);
    private final ListenerList keyListener = new ListenerList(1);
    private final ListenerList focusListener = new ListenerList(1);
    private final ListenerList javaCallbackListener = new ListenerList(1);
    private final RichTextEditorConfiguration editorConfig;
    private Shell embeddedShell;
    private Point mouseDragPosition;
    private boolean handleFocusChanges = true;
    public static final String JAR_UNPACK_LOCATION_PROPERTY = "org.eclipse.nebula.widgets.richtext.jar.unpackdir";
    private static URL templateURL;

    static {
        RichTextEditor.locateTemplateURL();
    }

    public RichTextEditor(Composite parent) {
        this(parent, (RichTextEditorConfiguration)null, 0);
    }

    @Deprecated
    public RichTextEditor(Composite parent, ToolbarConfiguration toolbarConfig) {
        this(parent, toolbarConfig, 0);
    }

    public RichTextEditor(Composite parent, RichTextEditorConfiguration editorConfig) {
        this(parent, editorConfig, 0);
    }

    public RichTextEditor(Composite parent, int style) {
        this(parent, (RichTextEditorConfiguration)null, style);
    }

    @Deprecated
    public RichTextEditor(Composite parent, ToolbarConfiguration toolbarConfig, int style) {
        this(parent, toolbarConfig != null ? new RichTextEditorConfiguration(toolbarConfig) : null, style);
    }

    public RichTextEditor(Composite parent, RichTextEditorConfiguration editorConfig, int style) {
        super(parent, style);
        boolean embedded;
        this.setLayout((Layout)new FillLayout());
        final boolean resizable = (this.getStyle() & 0x10) != 0;
        boolean bl = embedded = (this.getStyle() & 0x1000000) != 0;
        if (embedded) {
            this.embeddedShell = new Shell(parent.getShell(), 0);
            this.embeddedShell.setLayout((Layout)new FillLayout());
        }
        int browserStyle = style & 0xFFFFFFEF & 0xFFFFFF7F & 0xFEFFFFFF;
        this.browser = new Browser((Composite)(!embedded ? this : this.embeddedShell), browserStyle);
        this.browser.setJavascriptEnabled(true);
        this.editorConfig = editorConfig == null ? new RichTextEditorConfiguration() : editorConfig;
        this.editorConfig.setBrowser(this.browser);
        if (resizable) {
            boolean specifyMin = (this.getStyle() & 0x80) != 0;
            int minWidth = specifyMin ? this.getMinimumWidth() : 0;
            int minHeight = specifyMin ? this.getMinimumHeight() : 0;
            this.editorConfig.setResizable(resizable);
            this.editorConfig.setMinSize(minWidth, minHeight);
            this.editorConfig.setResizeDirection("both");
        }
        this.browser.setUrl(templateURL.toString());
        this.browserFunctions.add(new ModifyFunction(this.browser, "textModified"));
        this.browserFunctions.add(new KeyPressedFunction(this.browser, "keyPressed"));
        this.browserFunctions.add(new KeyReleasedFunction(this.browser, "keyReleased"));
        this.browserFunctions.add(new FocusInFunction(this.browser, "focusIn"));
        this.browserFunctions.add(new FocusOutFunction(this.browser, "focusOut"));
        this.browserFunctions.add(new JavaExecutionStartedFunction(this.browser, "javaExecutionStarted"));
        this.browserFunctions.add(new JavaExecutionFinishedFunction(this.browser, "javaExecutionFinished"));
        this.browserFunctions.add(new BrowserFunction(this.browser, "customizeToolbar"){

            public Object function(Object[] arguments) {
                RichTextEditor.this.editorConfig.customizeToolbar();
                return super.function(arguments);
            }
        });
        this.browserFunctions.add(new BrowserFunction(this.browser, "getAllOptions"){

            public Object function(Object[] arguments) {
                Map<String, Object> options = RichTextEditor.this.editorConfig.getAllOptions();
                Object[] result = new Object[options.size() * 2];
                int i = 0;
                for (Map.Entry<String, Object> entry : options.entrySet()) {
                    result[i++] = entry.getKey();
                    Object object = result[i++] = entry.getValue() != null ? entry.getValue() : "";
                }
                return result;
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                RichTextEditor.this.browser.evaluate("initEditor();");
                RichTextEditor.this.CKEDITOR_ALT = (Double)RichTextEditor.this.browser.evaluate("return getCKEditorALT()");
                RichTextEditor.this.CKEDITOR_CTRL = (Double)RichTextEditor.this.browser.evaluate("return getCKEditorCTRL()");
                RichTextEditor.this.CKEDITOR_SHIFT = (Double)RichTextEditor.this.browser.evaluate("return getCKEditorSHIFT()");
                RichTextEditor.this.editorLoaded = true;
                if (resizable && embedded) {
                    RichTextEditor.this.browserFunctions.add(new BrowserFunction(RichTextEditor.this.browser, "updateDimensions"){

                        public Object function(Object[] arguments) {
                            RichTextEditor.this.setInlineContainerBounds((this).RichTextEditor.this.getBounds().x, (this).RichTextEditor.this.getBounds().y, ((Double)arguments[0]).intValue() + 2, ((Double)arguments[1]).intValue() + 2);
                            if (RichTextEditor.this.getParent() != null) {
                                RichTextEditor.this.getParent().redraw();
                                RichTextEditor.this.getParent().update();
                            }
                            return super.function(arguments);
                        }
                    });
                    RichTextEditor.this.browser.evaluate("enableResizeCallback();");
                    if (embedded) {
                        RichTextEditor.this.browserFunctions.add(new BrowserFunction(RichTextEditor.this.browser, "activateShellDragMode"){

                            public Object function(Object[] arguments) {
                                RichTextEditor.this.mouseDragPosition = new Point(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue());
                                return super.function(arguments);
                            }
                        });
                        RichTextEditor.this.browserFunctions.add(new BrowserFunction(RichTextEditor.this.browser, "deactivateShellDragMode"){

                            public Object function(Object[] arguments) {
                                RichTextEditor.this.mouseDragPosition = null;
                                return super.function(arguments);
                            }
                        });
                        RichTextEditor.this.browserFunctions.add(new BrowserFunction(RichTextEditor.this.browser, "moveShell"){

                            public Object function(Object[] arguments) {
                                if (RichTextEditor.this.mouseDragPosition != null) {
                                    Point cursorLocation = Display.getDefault().getCursorLocation();
                                    RichTextEditor.this.embeddedShell.setLocation(cursorLocation.x - ((RichTextEditor)(this).RichTextEditor.this).mouseDragPosition.x, cursorLocation.y - ((RichTextEditor)(this).RichTextEditor.this).mouseDragPosition.y);
                                }
                                return super.function(arguments);
                            }
                        });
                        RichTextEditor.this.browser.evaluate("addMoveAnchor();");
                    }
                }
                if (RichTextEditor.this.initialValue != null) {
                    RichTextEditor.this.setText(RichTextEditor.this.initialValue);
                }
                if (RichTextEditor.this.initialSetFocus) {
                    RichTextEditor.this.setFocus();
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    public void dispose() {
        this.editorConfig.dispose();
        for (BrowserFunction function : this.browserFunctions) {
            function.dispose();
        }
        this.browser.dispose();
        if (this.embeddedShell != null && !this.embeddedShell.isDisposed()) {
            this.embeddedShell.dispose();
        }
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (this.embeddedShell != null && !this.embeddedShell.isDisposed()) {
            this.embeddedShell.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public String getText() {
        if (this.browser != null && !this.browser.isDisposed()) {
            Object result = this.browser.evaluate("return getText()");
            return result != null ? result.toString() : null;
        }
        return null;
    }

    public void setText(String text) {
        if (this.editorLoaded) {
            text = text.replace("\n", "\\n").replace("\r", "\\r");
            this.browser.evaluate("setText('" + text + "')");
        } else {
            this.initialValue = text;
        }
    }

    public void insertText(String text) {
        this.browser.evaluate("insertText('" + text + "')");
    }

    public void insertHTML(String html) {
        this.browser.evaluate("insertHTML('" + html + "')");
    }

    public String getSelectedText() {
        return "" + this.browser.evaluate("return getSelectedText();");
    }

    public String getSelectedHTML() {
        Object html = this.browser.evaluate("return getSelectedHTML()");
        return html != null ? html.toString() : "";
    }

    public boolean isEditable() {
        Object result = this.browser.evaluate("return isEditable()");
        return result != null ? !Boolean.valueOf(result.toString()).booleanValue() : true;
    }

    public void updateToolbar() {
        this.editorConfig.customizeToolbar();
        this.browser.evaluate("updateToolbar();");
    }

    public void updateEditor() {
        this.browser.evaluate("updateEditor();");
    }

    public void setEditable(boolean editable) {
        this.browser.evaluate("setReadOnly(" + !editable + ")");
    }

    public RichTextEditorConfiguration getEditorConfiguration() {
        return this.editorConfig;
    }

    public void setLanguage(Locale locale) {
        this.setLanguage(locale, true);
    }

    public void setLanguage(Locale locale, boolean update) {
        this.setLanguage(locale.getLanguage(), update);
    }

    public void setLanguage(String language) {
        this.setLanguage(language, true);
    }

    public void setLanguage(String language, boolean update) {
        this.editorConfig.setLanguage(language);
        if (update) {
            this.updateEditor();
        }
    }

    public void addToolbarButton(ToolbarButton button) {
        this.editorConfig.addToolbarButton(button);
    }

    public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
        this.editorConfig.addToolbarButton(button, function);
    }

    public void removeToolbarButton(ToolbarButton button) {
        this.editorConfig.removeToolbarButton(button);
    }

    public boolean setFocus() {
        if (this.editorLoaded) {
            this.browser.evaluate("setFocus();");
            Object result = this.browser.evaluate("return hasFocus();");
            return result != null ? Boolean.valueOf(result.toString()) : false;
        }
        this.initialSetFocus = true;
        return true;
    }

    public boolean forceFocus() {
        return this.setFocus();
    }

    public boolean isFocusControl() {
        if (this.editorLoaded) {
            Object result = this.browser.evaluate("return hasFocus();");
            return result != null ? Boolean.valueOf(result.toString()) : false;
        }
        return false;
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.focusListener.add((Object)listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.focusListener.remove((Object)listener);
    }

    public void notifyFocusGained(final FocusEvent event) {
        this.checkWidget();
        if (event == null || !this.handleFocusChanges) {
            return;
        }
        if (event.display != null) {
            event.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RichTextEditor.this.doNotifyFocusGained(event);
                }
            });
        } else {
            this.doNotifyFocusGained(event);
        }
    }

    private void doNotifyFocusGained(FocusEvent event) {
        Object[] listeners = this.focusListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((FocusListener)listeners[i]).focusGained(event);
            ++i;
        }
    }

    public void notifyFocusLost(final FocusEvent event) {
        this.checkWidget();
        if (event == null || !this.handleFocusChanges) {
            return;
        }
        if (event.display != null) {
            event.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RichTextEditor.this.doNotifyFocusLost(event);
                }
            });
        } else {
            this.doNotifyFocusLost(event);
        }
    }

    private void doNotifyFocusLost(FocusEvent event) {
        Object[] listeners = this.focusListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((FocusListener)listeners[i]).focusLost(event);
            ++i;
        }
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        int newX = x;
        int newY = y;
        int newWidth = width;
        int newHeight = height;
        if (this.resizedBounds != null) {
            newX = this.resizedBounds.x;
            newY = this.resizedBounds.y;
            newWidth = this.resizedBounds.width;
            newHeight = this.resizedBounds.height;
        } else if ((this.getStyle() & 0x1000000) != 0) {
            newHeight = Math.max(height, this.getMinimumHeight());
            newWidth = Math.max(width, this.getMinimumWidth());
        }
        if (this.embeddedShell != null) {
            Point shellLocation = super.toDisplay(newX, newY);
            this.embeddedShell.setBounds(shellLocation.x, shellLocation.y, newWidth, newHeight);
            this.embeddedShell.setVisible(true);
        } else {
            super.setBounds(newX, newY, newWidth, newHeight);
        }
    }

    void setInlineContainerBounds(int x, int y, int width, int height) {
        this.resizedBounds = new Rectangle(x, y, width, height);
        if (this.embeddedShell != null) {
            Point shellLocation = this.embeddedShell.getLocation();
            this.embeddedShell.setBounds(shellLocation.x, shellLocation.y, width + 2, height + 2);
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    protected int getMinimumHeight() {
        return 200;
    }

    protected int getMinimumWidth() {
        return 370;
    }

    public boolean executeJavascript(String script) {
        return this.browser.execute(script);
    }

    public Object evaluateJavascript(String script) {
        return this.browser.evaluate(script);
    }

    public boolean isHandleFocusChanges() {
        return this.handleFocusChanges;
    }

    public void setHandleFocusChanges(boolean handleFocusChanges) {
        this.handleFocusChanges = handleFocusChanges;
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.keyListener.add((Object)listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.keyListener.remove((Object)listener);
    }

    public void notifyKeyPressed(final KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            return;
        }
        if (event.display != null) {
            event.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RichTextEditor.this.doNotifyKeyPressed(event);
                }
            });
        } else {
            this.doNotifyKeyPressed(event);
        }
    }

    private void doNotifyKeyPressed(KeyEvent event) {
        Object[] listeners = this.keyListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((KeyListener)listeners[i]).keyPressed(event);
            ++i;
        }
    }

    public void notifyKeyReleased(final KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            return;
        }
        if (event.display != null) {
            event.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RichTextEditor.this.doNotifyKeyReleased(event);
                }
            });
        } else {
            this.doNotifyKeyReleased(event);
        }
    }

    private void doNotifyKeyReleased(KeyEvent event) {
        Object[] listeners = this.keyListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((KeyListener)listeners[i]).keyReleased(event);
            ++i;
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.modifyListener.add((Object)listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.modifyListener.remove((Object)listener);
    }

    public void notifyModifyListeners(final ModifyEvent event) {
        this.checkWidget();
        if (event == null) {
            return;
        }
        if (event.display != null) {
            event.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RichTextEditor.this.doNotifyModifyText(event);
                }
            });
        } else {
            this.doNotifyModifyText(event);
        }
    }

    private void doNotifyModifyText(ModifyEvent event) {
        Object[] listeners = this.modifyListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ModifyListener)listeners[i]).modifyText(event);
            ++i;
        }
    }

    private KeyEvent createKeyEvent(Double keyCode, Double modifier) {
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        event.keyCode = keyCode.intValue();
        Double modifierOnly = modifier - keyCode;
        if (modifierOnly != 0.0) {
            if (modifierOnly.equals(this.CKEDITOR_ALT + this.CKEDITOR_CTRL + this.CKEDITOR_SHIFT)) {
                event.stateMask = SWT.MOD3 | SWT.MOD1 | SWT.MOD2;
            } else if (modifierOnly.equals(this.CKEDITOR_ALT + this.CKEDITOR_CTRL)) {
                event.stateMask = SWT.MOD3 | SWT.MOD1;
            } else if (modifierOnly.equals(this.CKEDITOR_ALT + this.CKEDITOR_SHIFT)) {
                event.stateMask = SWT.MOD3 | SWT.MOD2;
            } else if (modifierOnly.equals(this.CKEDITOR_CTRL + this.CKEDITOR_SHIFT)) {
                event.stateMask = SWT.MOD1 | SWT.MOD2;
            } else if (modifierOnly.equals(this.CKEDITOR_ALT)) {
                event.stateMask = SWT.MOD3;
            } else if (modifierOnly.equals(this.CKEDITOR_CTRL)) {
                event.stateMask = SWT.MOD1;
            } else if (modifierOnly.equals(this.CKEDITOR_SHIFT)) {
                event.stateMask = SWT.MOD2;
            }
        }
        switch (event.keyCode) {
            case 33: {
                event.keyCode = 0x1000005;
                break;
            }
            case 34: {
                event.keyCode = 0x1000006;
                break;
            }
            case 35: {
                event.keyCode = 0x1000008;
                break;
            }
            case 36: {
                event.keyCode = 0x1000007;
                break;
            }
            case 37: {
                event.keyCode = 0x1000003;
                break;
            }
            case 38: {
                event.keyCode = 0x1000001;
                break;
            }
            case 39: {
                event.keyCode = 0x1000004;
                break;
            }
            case 40: {
                event.keyCode = 0x1000002;
                break;
            }
            case 45: {
                event.keyCode = 0x1000009;
                break;
            }
            case 46: {
                event.keyCode = 127;
                break;
            }
            case 96: {
                event.keyCode = 0x1000030;
                event.character = (char)48;
                break;
            }
            case 97: {
                event.keyCode = 0x1000031;
                event.character = (char)49;
                break;
            }
            case 98: {
                event.keyCode = 16777266;
                event.character = (char)50;
                break;
            }
            case 99: {
                event.keyCode = 0x1000033;
                event.character = (char)51;
                break;
            }
            case 100: {
                event.keyCode = 16777268;
                event.character = (char)52;
                break;
            }
            case 101: {
                event.keyCode = 16777269;
                event.character = (char)53;
                break;
            }
            case 102: {
                event.keyCode = 16777270;
                event.character = (char)54;
                break;
            }
            case 103: {
                event.keyCode = 16777271;
                event.character = (char)55;
                break;
            }
            case 104: {
                event.keyCode = 16777272;
                event.character = (char)56;
                break;
            }
            case 105: {
                event.keyCode = 16777273;
                event.character = (char)57;
                break;
            }
            case 106: {
                event.keyCode = 16777258;
                event.character = (char)42;
                break;
            }
            case 107: {
                event.keyCode = 16777259;
                event.character = (char)43;
                break;
            }
            case 109: {
                event.keyCode = 16777261;
                event.character = (char)45;
                break;
            }
            case 110: {
                event.keyCode = 16777262;
                event.character = (char)44;
                break;
            }
            case 111: {
                event.keyCode = 16777263;
                event.character = (char)47;
                break;
            }
            case 112: {
                event.keyCode = 0x100000A;
                break;
            }
            case 113: {
                event.keyCode = 0x100000B;
                break;
            }
            case 114: {
                event.keyCode = 0x100000C;
                break;
            }
            case 115: {
                event.keyCode = 0x100000D;
                break;
            }
            case 116: {
                event.keyCode = 0x100000E;
                break;
            }
            case 117: {
                event.keyCode = 0x100000F;
                break;
            }
            case 118: {
                event.keyCode = 0x1000010;
                break;
            }
            case 119: {
                event.keyCode = 0x1000011;
                break;
            }
            case 120: {
                event.keyCode = 0x1000012;
                break;
            }
            case 121: {
                event.keyCode = 0x1000013;
                break;
            }
            case 122: {
                event.keyCode = 0x1000014;
                break;
            }
            case 123: {
                event.keyCode = 0x1000015;
            }
        }
        String keyCharString = SWTKeySupport.getKeyFormatterForPlatform().format(event.keyCode);
        if (keyCharString.length() == 1) {
            char keyChar = keyCharString.charAt(0);
            if (Character.isUpperCase(keyChar) && Character.isAlphabetic(keyChar)) {
                event.character = (event.stateMask & SWT.MOD2) != SWT.MOD2 ? Character.toLowerCase(keyChar) : keyChar;
            } else if (Character.isDigit(keyChar) && (event.stateMask & SWT.MOD2) != SWT.MOD2 && (event.stateMask & SWT.MOD3) != SWT.MOD3) {
                event.character = keyChar;
            }
        }
        return new KeyEvent(event);
    }

    public void addJavaCallbackListener(JavaCallbackListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.javaCallbackListener.add((Object)listener);
    }

    public void removeJavaCallbackListener(JavaCallbackListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.javaCallbackListener.remove((Object)listener);
    }

    private void doNotifyJavaExecutionStarted() {
        Object[] listeners = this.javaCallbackListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((JavaCallbackListener)listeners[i]).javaExecutionStarted();
            ++i;
        }
    }

    private void doNotifyJavaExecutionFinished() {
        Object[] listeners = this.javaCallbackListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((JavaCallbackListener)listeners[i]).javaExecutionFinished();
            ++i;
        }
    }

    private FocusEvent createFocusEvent() {
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        return new FocusEvent(event);
    }

    private ModifyEvent createModifyEvent() {
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        return new ModifyEvent(event);
    }

    private static void locateTemplateURL() {
        templateURL = RichTextEditor.class.getResource("resources/template.html");
        Bundle bundle = FrameworkUtil.getBundle(RichTextEditor.class);
        if (bundle != null) {
            try {
                templateURL = FileLocator.toFileURL((URL)templateURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (templateURL.toString().startsWith("jar")) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    URL jarURL = RichTextEditor.class.getProtectionDomain().getCodeSource().getLocation();
                    File jarFileReference = null;
                    if (jarURL.getProtocol().equals("file")) {
                        try {
                            String decodedPath = URLDecoder.decode(jarURL.getPath(), "UTF-8");
                            jarFileReference = new File(decodedPath);
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            final Path jar = Files.createTempFile("richtext", ".jar", new FileAttribute[0]);
                            Files.copy(jarURL.openStream(), jar, StandardCopyOption.REPLACE_EXISTING);
                            jarFileReference = jar.toFile();
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Files.delete(jar);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (jarFileReference == null) return;
                    try {
                        Throwable e = null;
                        Object var4_8 = null;
                        try (JarFile jarFile = new JarFile(jarFileReference);){
                            Path tempDir;
                            String unpackDirectory = System.getProperty(RichTextEditor.JAR_UNPACK_LOCATION_PROPERTY);
                            Path path = tempDir = unpackDirectory == null ? Files.createTempDirectory("richtext", new FileAttribute[0]) : Files.createDirectories(Paths.get(unpackDirectory, new String[0]), new FileAttribute[0]);
                            if (unpackDirectory == null) {
                                Runtime.getRuntime().addShutdownHook(new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                                @Override
                                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                                    Files.delete(file);
                                                    return FileVisitResult.CONTINUE;
                                                }

                                                @Override
                                                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                                    Files.delete(dir);
                                                    return FileVisitResult.CONTINUE;
                                                }
                                            });
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                            Enumeration<JarEntry> entries = jarFile.entries();
                            while (true) {
                                File file;
                                String name;
                                block35: {
                                    if (!entries.hasMoreElements()) {
                                        return;
                                    }
                                    JarEntry entry = entries.nextElement();
                                    name = entry.getName();
                                    if (!name.startsWith("org/eclipse/nebula/widgets/richtext/resources")) continue;
                                    file = new File(tempDir.toAbsolutePath() + File.separator + name);
                                    if (!file.exists()) {
                                        if (entry.isDirectory()) {
                                            file.mkdirs();
                                        } else {
                                            Throwable throwable = null;
                                            Object var13_19 = null;
                                            try {
                                                InputStream is = jarFile.getInputStream(entry);
                                                try {
                                                    try (FileOutputStream os = new FileOutputStream(file);){
                                                        while (is.available() > 0) {
                                                            ((OutputStream)os).write(is.read());
                                                        }
                                                    }
                                                    if (is == null) break block35;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (is == null) throw throwable;
                                                    is.close();
                                                    throw throwable;
                                                }
                                                is.close();
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable == null) {
                                                    throwable = throwable3;
                                                    throw throwable;
                                                }
                                                if (throwable == throwable3) throw throwable;
                                                throwable.addSuppressed(throwable3);
                                                throw throwable;
                                            }
                                        }
                                    }
                                }
                                if (!name.endsWith("template.html")) continue;
                                templateURL = file.toURI().toURL();
                            }
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                                throw e;
                            }
                            if (e == throwable) throw e;
                            e.addSuppressed(throwable);
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    class FocusInFunction
    extends BrowserFunction {
        public FocusInFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RichTextEditor.this.notifyFocusGained(RichTextEditor.this.createFocusEvent());
            return super.function(arguments);
        }
    }

    class FocusOutFunction
    extends BrowserFunction {
        public FocusOutFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RichTextEditor.this.notifyFocusLost(RichTextEditor.this.createFocusEvent());
            return super.function(arguments);
        }
    }

    class JavaExecutionFinishedFunction
    extends BrowserFunction {
        public JavaExecutionFinishedFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RichTextEditor.this.doNotifyJavaExecutionFinished();
            return super.function(arguments);
        }
    }

    class JavaExecutionStartedFunction
    extends BrowserFunction {
        public JavaExecutionStartedFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RichTextEditor.this.doNotifyJavaExecutionStarted();
            return super.function(arguments);
        }
    }

    class KeyPressedFunction
    extends BrowserFunction {
        public KeyPressedFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            Double keyCode = (Double)arguments[0];
            Double modifier = (Double)arguments[1];
            RichTextEditor.this.notifyKeyPressed(RichTextEditor.this.createKeyEvent(keyCode, modifier));
            return super.function(arguments);
        }
    }

    class KeyReleasedFunction
    extends BrowserFunction {
        public KeyReleasedFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            Double keyCode = (Double)arguments[0];
            Double modifier = (Double)arguments[1];
            RichTextEditor.this.notifyKeyReleased(RichTextEditor.this.createKeyEvent(keyCode, modifier));
            return super.function(arguments);
        }
    }

    class ModifyFunction
    extends BrowserFunction {
        public ModifyFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            RichTextEditor.this.notifyModifyListeners(RichTextEditor.this.createModifyEvent());
            return super.function(arguments);
        }
    }
}

