/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.net.SslCertificateException;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.MonitoredRequest;
import org.eclipse.mylyn.internal.commons.net.TrustAllTrustManager;

public class PollingSslProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final String KEY_STORE = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private final boolean hasKeyManager;
    private String keyStoreFileName;
    private String keyStorePassword;
    private String keyStoreType;
    private SSLSocketFactory socketFactory;

    public PollingSslProtocolSocketFactory() {
        KeyManager[] keymanagers = null;
        if (System.getProperty(KEY_STORE) != null && System.getProperty(KEY_STORE_PASSWORD) != null) {
            try {
                String type = System.getProperty(KEY_STORE_TYPE, KeyStore.getDefaultType());
                KeyStore keyStore = KeyStore.getInstance(type);
                char[] password = System.getProperty(KEY_STORE_PASSWORD).toCharArray();
                keyStore.load(new FileInputStream(System.getProperty(KEY_STORE)), password);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, password);
                keymanagers = keyManagerFactory.getKeyManagers();
            }
            catch (Exception e) {
                CommonsNetPlugin.log(4, "Could not initialize keystore", e);
            }
        }
        this.hasKeyManager = keymanagers != null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keymanagers, new TrustManager[]{new TrustAllTrustManager()}, null);
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            CommonsNetPlugin.log(4, "Could not initialize SSL context", e);
        }
    }

    public PollingSslProtocolSocketFactory(String keyStoreFileName, String keyStorePassword, String keyStoreType) {
        this.keyStoreFileName = keyStoreFileName;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.hasKeyManager = false;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return NetUtil.configureSocket((Socket)this.getSocketFactory().createSocket(socket, host, port, autoClose));
    }

    public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
        return NetUtil.configureSocket((Socket)this.getSocketFactory().createSocket(remoteHost, remotePort));
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return NetUtil.configureSocket((Socket)this.getSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort));
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        Socket socket = NetUtil.configureSocket((Socket)this.getSocketFactory().createSocket());
        socket.bind(new InetSocketAddress(localAddress, localPort));
        MonitoredRequest.connect(socket, new InetSocketAddress(host, port), timeout);
        return socket;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PollingSslProtocolSocketFactory other = (PollingSslProtocolSocketFactory)obj;
        if (this.keyStoreFileName == null ? other.keyStoreFileName != null : !this.keyStoreFileName.equals(other.keyStoreFileName)) {
            return false;
        }
        if (this.keyStorePassword == null ? other.keyStorePassword != null : !this.keyStorePassword.equals(other.keyStorePassword)) {
            return false;
        }
        return !(this.keyStoreType == null ? other.keyStoreType != null : !this.keyStoreType.equals(other.keyStoreType));
    }

    public synchronized SSLSocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            if (this.keyStoreFileName != null && this.keyStorePassword != null) {
                KeyManager[] keymanagers = null;
                try {
                    if (this.keyStoreType == null) {
                        try {
                            keymanagers = this.openKeyStore(KeyStore.getDefaultType());
                        }
                        catch (Exception e) {
                            keymanagers = this.openKeyStore("pkcs12");
                        }
                    } else {
                        keymanagers = this.openKeyStore(this.keyStoreType);
                    }
                }
                catch (Exception cause) {
                    SslCertificateException e = new SslCertificateException();
                    e.initCause(cause);
                    throw e;
                }
                try {
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(keymanagers, new TrustManager[]{new TrustAllTrustManager()}, null);
                    this.socketFactory = sslContext.getSocketFactory();
                }
                catch (Exception cause) {
                    SslCertificateException e = new SslCertificateException();
                    e.initCause(cause);
                    throw e;
                }
            }
            throw new IOException("Could not initialize SSL context");
        }
        return this.socketFactory;
    }

    private KeyManager[] openKeyStore(String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(type);
        char[] password = this.keyStorePassword.toCharArray();
        keyStore.load(new FileInputStream(this.keyStoreFileName), password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        return keyManagerFactory.getKeyManagers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStoreFileName == null ? 0 : this.keyStoreFileName.hashCode());
        result = 31 * result + (this.keyStorePassword == null ? 0 : this.keyStorePassword.hashCode());
        result = 31 * result + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        return result;
    }

    public boolean hasKeyManager() {
        return this.hasKeyManager;
    }
}

