/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class ServerMessageHandler {
    private static final String NAME_PATTERN = "%s (%s)";

    private ServerMessageHandler() {
    }

    public static void logMessage(IProject project, String serverLabel, MessageParams params) {
        MessageConsole console = ServerMessageHandler.findConsole(String.format(NAME_PATTERN, serverLabel, project.getName()));
        console.newMessageStream().println(String.format("[%s]\t%s", params.getType(), params.getMessage()));
    }

    public static void showMessage(MessageParams params) {
        LSPNotification notification = new LSPNotification(String.format("LSP (%s)", params.getType()), params.getMessage());
        NotificationsUi.getService().notify(Collections.singletonList(notification));
    }

    public static CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams params) {
        return null;
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private static class LSPNotification
    extends AbstractNotification {
        private String label;
        private String description;

        public LSPNotification(String label, String description) {
            super("lsp.notification");
            this.label = label;
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public Date getDate() {
            return new Date();
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }
}

