/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.newwizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.InfrastructureCreator;
import org.eclipse.libra.warproducts.core.WARProduct;
import org.eclipse.libra.warproducts.core.WARProductInitializer;
import org.eclipse.libra.warproducts.core.WARWorkspaceProductModel;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.product.BaseProductCreationOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class BaseWARProductCreationOperation
extends BaseProductCreationOperation {
    private IContainer productParent;
    private IFile file;

    public BaseWARProductCreationOperation(IFile file) {
        super(file);
        this.productParent = file.getParent();
        this.file = file;
    }

    protected void initializeProduct(IProduct product) {
        super.initializeProduct(product);
        InfrastructureCreator creator = new InfrastructureCreator(this.productParent);
        this.createWebInfContent(creator);
        if (product instanceof WARProduct) {
            WARProduct warProduct = (WARProduct)product;
            warProduct.addLaunchIni(creator.getLaunchIniPath());
            warProduct.addWebXml(creator.getWebXmlPath());
            WARProductInitializer initializer = new WARProductInitializer((IWARProduct)warProduct);
            initializer.initialize();
        }
    }

    protected void createWebInfContent(InfrastructureCreator creator) {
        try {
            creator.createWebInf();
            creator.createLaunchIni();
            creator.createWebXml();
        }
        catch (CoreException e) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)Messages.NewWARProductError, (String)e.getMessage());
        }
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.BaseWARProductCreationOperation, 2);
        this.createContent();
        monitor.worked(1);
        this.openFile();
        monitor.done();
    }

    private void createContent() {
        WARWorkspaceProductModel model = new WARWorkspaceProductModel(this.file, false);
        this.initializeProduct(model.getProduct());
        model.save();
        model.dispose();
    }

    private void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null && BaseWARProductCreationOperation.this.file.exists()) {
                    IWorkbenchPart focusPart = page.getActivePart();
                    if (focusPart instanceof ISetSelectionTarget) {
                        StructuredSelection selection = new StructuredSelection((Object)BaseWARProductCreationOperation.this.file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)BaseWARProductCreationOperation.this.file, (String)"org.eclipse.libra.warproducts.WARProductEditor");
                    }
                    catch (PartInitException e) {
                        PDECore.log((Throwable)e);
                    }
                }
            }
        });
    }
}

