/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.internal;

import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CombinedImageDescriptor
extends ImageDescriptor {
    private ImageDescriptor[] imageDescriptors;

    public CombinedImageDescriptor(ImageDescriptor[] imageDescriptors) {
        assert (imageDescriptors != null);
        this.imageDescriptors = imageDescriptors;
    }

    public ImageDescriptor[] getImageDescriptors() {
        return this.imageDescriptors;
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        ImageDescriptor[] imageDescriptorArray = this.imageDescriptors;
        int n = this.imageDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor imageDescriptor = imageDescriptorArray[n2];
            if (imageDescriptor != null) {
                try {
                    Image image = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(imageDescriptor);
                    if (image != null) {
                        return image;
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            ++n2;
        }
        if (returnMissingImageOnError) {
            return Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(CombinedImageDescriptor.getMissingImageDescriptor());
        }
        return null;
    }

    public ImageData getImageData() {
        ImageDescriptor[] imageDescriptorArray = this.imageDescriptors;
        int n = this.imageDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor imageDescriptor = imageDescriptorArray[n2];
            if (imageDescriptor != null) {
                try {
                    ImageData imageData = imageDescriptor.getImageData();
                    if (imageData != null) {
                        return imageData;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return null;
    }

    public Image createImage() {
        return this.createImage(true, null);
    }

    public String toString() {
        return Arrays.toString(this.imageDescriptors);
    }
}

