/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

@Command(usage="usage_RebuildRefTree")
class RebuildRefTree
extends TextBuiltin {
    @Option(name="--enable", usage="usage_RebuildRefTreeEnable")
    boolean enable;
    private String txnNamespace;
    private String txnCommitted;

    RebuildRefTree() {
    }

    @Override
    protected void run() throws Exception {
        try (ObjectReader reader = this.db.newObjectReader();
             RevWalk rw = new RevWalk(reader);
             ObjectInserter inserter = this.db.newObjectInserter();){
            ObjectId oldTreeId;
            RefTreeDatabase d;
            RefDatabase refDb = this.db.getRefDatabase();
            if (refDb instanceof RefTreeDatabase) {
                d = (RefTreeDatabase)refDb;
                refDb = d.getBootstrap();
                this.txnNamespace = d.getTxnNamespace();
                this.txnCommitted = d.getTxnCommitted();
            } else {
                d = new RefTreeDatabase(this.db, refDb);
                this.txnNamespace = d.getTxnNamespace();
                this.txnCommitted = d.getTxnCommitted();
            }
            this.errw.format("Rebuilding %s from %s", new Object[]{this.txnCommitted, refDb.getClass().getSimpleName()});
            this.errw.println();
            this.errw.flush();
            CommitBuilder b = new CommitBuilder();
            Ref ref = refDb.exactRef(this.txnCommitted);
            RefUpdate update = refDb.newUpdate(this.txnCommitted, true);
            if (ref != null && ref.getObjectId() != null) {
                ObjectId oldId = ref.getObjectId();
                update.setExpectedOldObjectId((AnyObjectId)oldId);
                b.setParentId((AnyObjectId)oldId);
                oldTreeId = rw.parseCommit((AnyObjectId)oldId).getTree();
            } else {
                update.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                oldTreeId = ObjectId.zeroId();
            }
            RefTree tree = this.rebuild(refDb);
            b.setTreeId((AnyObjectId)tree.writeTree(inserter));
            b.setAuthor(new PersonIdent(this.db));
            b.setCommitter(b.getAuthor());
            if (b.getTreeId().equals((AnyObjectId)oldTreeId)) {
                return;
            }
            update.setNewObjectId((AnyObjectId)inserter.insert(b));
            inserter.flush();
            RefUpdate.Result result = update.update(rw);
            switch (result) {
                case NEW: 
                case FAST_FORWARD: {
                    break;
                }
                default: {
                    throw RebuildRefTree.die(String.format("%s: %s", update.getName(), result));
                }
            }
            if (this.enable && !(this.db.getRefDatabase() instanceof RefTreeDatabase)) {
                StoredConfig cfg = this.db.getConfig();
                cfg.setInt("core", null, "repositoryformatversion", 1);
                cfg.setString("extensions", null, "refStorage", "reftree");
                cfg.save();
                this.errw.println("Enabled reftree.");
                this.errw.flush();
            }
        }
    }

    private RefTree rebuild(RefDatabase refdb) throws IOException {
        RefTree tree = RefTree.newEmptyTree();
        ArrayList<org.eclipse.jgit.internal.storage.reftree.Command> cmds = new ArrayList<org.eclipse.jgit.internal.storage.reftree.Command>();
        Ref head = refdb.exactRef("HEAD");
        if (head != null) {
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, head));
        }
        for (Ref r : refdb.getRefs("").values()) {
            if (r.getName().equals(this.txnCommitted) || r.getName().equals("HEAD") || r.getName().startsWith(this.txnNamespace)) continue;
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, this.db.peel(r)));
        }
        tree.apply(cmds);
        return tree;
    }
}

