/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RenameKeysDialog
extends StatusDialog {
    private StringDialogField fNameField;
    private List<NLSSubstitution> fSelectedSubstitutions;
    private int fCommonPrefixLength;

    public RenameKeysDialog(Shell parent, List<NLSSubstitution> selectedSubstitutions) {
        super(parent);
        this.setTitle(NLSUIMessages.RenameKeysDialog_title);
        this.fSelectedSubstitutions = selectedSubstitutions;
        String prefix = this.getInitialPrefix(selectedSubstitutions);
        this.fCommonPrefixLength = prefix.length();
        this.fNameField = new StringDialogField();
        this.fNameField.setText(prefix);
        if (prefix.length() == 0) {
            this.fNameField.setLabelText(NLSUIMessages.RenameKeysDialog_description_noprefix);
        } else {
            this.fNameField.setLabelText(String.valueOf(NLSUIMessages.RenameKeysDialog_description_withprefix) + prefix + ':');
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fNameField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        return composite;
    }

    protected void okPressed() {
        String prefix = this.fNameField.getText();
        int i = 0;
        while (i < this.fSelectedSubstitutions.size()) {
            NLSSubstitution sub = this.fSelectedSubstitutions.get(i);
            String newKey = String.valueOf(prefix) + sub.getKey().substring(this.fCommonPrefixLength);
            sub.setKey(newKey);
            ++i;
        }
        super.okPressed();
    }

    private String getInitialPrefix(List<NLSSubstitution> selectedSubstitutions) {
        String prefix = null;
        int i = 0;
        while (i < selectedSubstitutions.size()) {
            NLSSubstitution sub = selectedSubstitutions.get(i);
            String curr = sub.getKey();
            if (prefix == null) {
                prefix = curr;
            } else if (!curr.startsWith(prefix) && (prefix = this.getCommonPrefix(prefix, curr)).length() == 0) {
                return prefix;
            }
            ++i;
        }
        return prefix;
    }

    private String getCommonPrefix(String a, String b) {
        String shorter = a.length() <= b.length() ? a : b;
        int len = shorter.length();
        int i = 0;
        while (i < len) {
            if (a.charAt(i) != b.charAt(i)) {
                return a.substring(0, i);
            }
            ++i;
        }
        return shorter;
    }
}

