/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;

public class TypeRules {
    public static boolean canAssign(ITypeBinding typeToAssign, ITypeBinding definedType) {
        TypeEnvironment typeEnvironment = new TypeEnvironment(false, true);
        TType defined = typeEnvironment.create(definedType);
        TType toAssign = typeEnvironment.create(typeToAssign);
        return toAssign.canAssignTo(defined);
    }

    public static boolean isArrayCompatible(ITypeBinding definedType) {
        if (definedType.isTopLevel()) {
            if (definedType.isClass()) {
                return "Object".equals(definedType.getName()) && "java.lang".equals(definedType.getPackage().getName());
            }
            String qualifiedName = definedType.getQualifiedName();
            return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
        }
        return false;
    }

    public static boolean isJavaLangObject(ITypeBinding definedType) {
        return definedType.isTopLevel() && definedType.isClass() && "Object".equals(definedType.getName()) && "java.lang".equals(definedType.getPackage().getName());
    }

    public static boolean canCast(ITypeBinding castType, ITypeBinding bindingToCast) {
        String voidName = PrimitiveType.VOID.toString();
        if (castType.isAnonymous() || castType.isNullType() || voidName.equals(castType.getName())) {
            throw new IllegalArgumentException();
        }
        if (castType == bindingToCast) {
            return true;
        }
        if (voidName.equals(bindingToCast.getName())) {
            return false;
        }
        if (bindingToCast.isArray()) {
            int castTypeDim;
            if (!castType.isArray()) {
                return TypeRules.isArrayCompatible(castType);
            }
            int toCastDim = bindingToCast.getDimensions();
            if (toCastDim == (castTypeDim = castType.getDimensions())) {
                bindingToCast = bindingToCast.getElementType();
                if ((castType = castType.getElementType()).isPrimitive() && castType != bindingToCast) {
                    return false;
                }
            } else {
                if (toCastDim < castTypeDim) {
                    return TypeRules.isArrayCompatible(bindingToCast.getElementType());
                }
                return TypeRules.isArrayCompatible(castType.getElementType());
            }
        }
        if (castType.isPrimitive()) {
            if (!bindingToCast.isPrimitive()) {
                return false;
            }
            String boolName = PrimitiveType.BOOLEAN.toString();
            return !boolName.equals(castType.getName()) && !boolName.equals(bindingToCast.getName());
        }
        if (bindingToCast.isPrimitive()) {
            return false;
        }
        if (castType.isArray()) {
            return TypeRules.isArrayCompatible(bindingToCast);
        }
        if (castType.isInterface()) {
            if ((bindingToCast.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(castType, bindingToCast);
            }
            return true;
        }
        if (bindingToCast.isInterface()) {
            if ((castType.getModifiers() & 0x10) != 0) {
                return Bindings.isSuperType(bindingToCast, castType);
            }
            return true;
        }
        if (TypeRules.isJavaLangObject(castType)) {
            return true;
        }
        return Bindings.isSuperType(bindingToCast, castType) || Bindings.isSuperType(castType, bindingToCast);
    }
}

