/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.filters;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbench;

import com.google.common.base.Predicate;

public class ActiveWorkbenchStatusFilter implements Predicate<IStatus> {

    private IWorkbench workbench;

    public ActiveWorkbenchStatusFilter(IWorkbench workbench) {
        this.workbench = workbench;
    }

    @Override
    public boolean apply(@Nullable IStatus input) {
        return !workbench.isClosing();
    }
}
