/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class LayoutHelper {
    public static final int MINIMUM_WEIGHT = 30;

    public Layout adjustForTableLayout(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        Layout layout = null;
        Layout parentLayout = table.getParent().getLayout();
        if (parentLayout instanceof TableColumnLayout) {
            layout = parentLayout;
        } else {
            layout = new TableLayout();
            table.setLayout(layout);
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return layout;
    }

    public Layout adjustForTableLayout(TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        Layout layout = null;
        Layout parentLayout = tree.getParent().getLayout();
        if (parentLayout instanceof TreeColumnLayout) {
            layout = parentLayout;
        } else {
            layout = new TableLayout();
            tree.setLayout(layout);
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        return layout;
    }

    public void adjustLayoutColumnData(Layout layout, Widget column, int weight) {
        if (layout instanceof AbstractColumnLayout) {
            ((AbstractColumnLayout)layout).setColumnData(column, (ColumnLayoutData)this.createColumnWeightData(weight));
        } else if (layout instanceof TableLayout) {
            ((TableLayout)layout).addColumnData((ColumnLayoutData)this.createColumnWeightData(weight));
        }
    }

    protected ColumnWeightData createColumnWeightData(int weight) {
        return new ColumnWeightData(weight, 30, true);
    }
}

