/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.efacet.core.internal.Activator;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolver;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverManager
implements IResolverManager {
    private static final String ATT_NAME = "class";
    private static final String EXT_POINT_ID = "org.eclipse.emf.facet.efacet.core.internal.resolver";
    private final List<IResolver> resolvers = new ArrayList<IResolver>();

    public ResolverManager() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                Object object = config.createExecutableExtension(ATT_NAME);
                if (object instanceof IResolver) {
                    IResolver resolver = (IResolver)object;
                    this.resolvers.add(resolver);
                }
            }
            catch (CoreException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            ++n2;
        }
    }

    @Override
    public <T> T resolve(Object object, Class<T> aClass) {
        T result = null;
        for (IResolver resolver : this.resolvers) {
            if (!resolver.canHandle(object)) continue;
            try {
                result = resolver.resolve(object, aClass);
            }
            catch (ClassCastException e) {
                Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
            }
            if (result != null) break;
        }
        return result;
    }

    @Override
    public <T> List<T> selectionPropagation(Object selectedObject, Class<T> aClass) {
        List<T> result = Collections.EMPTY_LIST;
        for (IResolver resolver : this.resolvers) {
            if (!resolver.canHandle(selectedObject)) continue;
            try {
                result = resolver.selectionPropagation(selectedObject, aClass);
            }
            catch (ClassCastException e) {
                Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
            }
            if (result != null) break;
        }
        return result;
    }

    @Override
    public <T> T selectionRoot(Object selectedObject, Class<T> aClass) {
        T result = null;
        for (IResolver resolver : this.resolvers) {
            if (!resolver.canHandle(selectedObject)) continue;
            try {
                result = resolver.selectionRoot(selectedObject, aClass);
            }
            catch (ClassCastException e) {
                Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
            }
            if (result != null) break;
        }
        return result;
    }
}

