/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndicationWithMonitoring;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadMergeDataIndication
extends CDOServerReadIndicationWithMonitoring {
    private CDORevisionAvailabilityInfo targetInfo;
    private CDORevisionAvailabilityInfo sourceInfo;
    private CDORevisionAvailabilityInfo targetBaseInfo;
    private CDORevisionAvailabilityInfo sourceBaseInfo;
    private int infos;
    private boolean auto;

    public LoadMergeDataIndication(CDOServerProtocol protocol) {
        super(protocol, (short)45);
    }

    protected int getIndicatingWorkPercent() {
        return 10;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.infos = in.readXInt();
        monitor.begin((double)this.infos);
        try {
            this.targetInfo = this.readRevisionAvailabilityInfo(in, monitor.fork());
            this.sourceInfo = this.readRevisionAvailabilityInfo(in, monitor.fork());
            if (this.infos > 2) {
                this.targetBaseInfo = this.readRevisionAvailabilityInfo(in, monitor.fork());
            }
            if (this.infos > 3) {
                this.sourceBaseInfo = this.readRevisionAvailabilityInfo(in, monitor.fork());
            }
        }
        finally {
            monitor.done();
        }
    }

    private CDORevisionAvailabilityInfo readRevisionAvailabilityInfo(CDODataInput in, OMMonitor monitor) throws IOException {
        if (in.readBoolean()) {
            CDOBranchPoint branchPoint = in.readCDOBranchPoint();
            CDORevisionAvailabilityInfo info = new CDORevisionAvailabilityInfo(branchPoint);
            int size = in.readXInt();
            monitor.begin((double)size);
            try {
                int i = 0;
                while (i < size) {
                    CDOID id = in.readCDOID();
                    info.getAvailableRevisions().put(id, null);
                    monitor.worked();
                    ++i;
                }
                CDORevisionAvailabilityInfo cDORevisionAvailabilityInfo = info;
                return cDORevisionAvailabilityInfo;
            }
            finally {
                monitor.done();
            }
        }
        this.auto = true;
        return new CDORevisionAvailabilityInfo(CDOBranchUtil.AUTO_BRANCH_POINT);
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        monitor.begin((double)(2 + this.infos));
        try {
            InternalRepository repository = this.getRepository();
            CDOSessionProtocol.MergeDataResult result = repository.getMergeData2(this.targetInfo, this.sourceInfo, this.targetBaseInfo, this.sourceBaseInfo, monitor.fork());
            Set targetIDs = result.getTargetIDs();
            HashSet<CDOID> targetAndSourceIDs = new HashSet<CDOID>();
            Set sourceIDs = result.getSourceIDs();
            for (CDOID id : targetIDs) {
                if (sourceIDs.remove(id)) {
                    targetAndSourceIDs.add(id);
                    continue;
                }
                out.writeCDOID(id);
            }
            out.writeCDOID(null);
            for (CDOID id : targetAndSourceIDs) {
                out.writeCDOID(id);
            }
            out.writeCDOID(null);
            for (CDOID id : sourceIDs) {
                out.writeCDOID(id);
            }
            out.writeCDOID(null);
            monitor.worked();
            if (this.auto) {
                out.writeCDOBranchPoint(this.targetBaseInfo.getBranchPoint());
                if (this.targetBaseInfo.getBranchPoint().equals(this.sourceBaseInfo.getBranchPoint())) {
                    out.writeBoolean(false);
                    this.infos = 3;
                } else {
                    out.writeBoolean(true);
                    out.writeCDOBranchPoint(this.sourceBaseInfo.getBranchPoint());
                }
            }
            HashSet<CDORevisionKey> writtenRevisions = new HashSet<CDORevisionKey>();
            this.writeRevisionAvailabilityInfo(out, this.targetInfo, writtenRevisions, monitor.fork());
            this.writeRevisionAvailabilityInfo(out, this.sourceInfo, writtenRevisions, monitor.fork());
            if (this.infos > 2) {
                this.writeRevisionAvailabilityInfo(out, this.targetBaseInfo, writtenRevisions, monitor.fork());
            }
            if (this.infos > 3) {
                this.writeRevisionAvailabilityInfo(out, this.sourceBaseInfo, writtenRevisions, monitor.fork());
            }
            CDOBranchUtil.writeBranchPointOrNull((CDODataOutput)out, (CDOBranchPoint)result.getResultBase());
        }
        finally {
            monitor.done();
        }
    }

    private void writeRevisionAvailabilityInfo(CDODataOutput out, CDORevisionAvailabilityInfo info, Set<CDORevisionKey> writtenRevisions, OMMonitor monitor) throws IOException {
        Collection revisions = info.getAvailableRevisions().values();
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            CDORevisionKey key = (CDORevisionKey)it.next();
            if (key != null) continue;
            it.remove();
        }
        int size = revisions.size();
        out.writeXInt(size);
        monitor.begin((double)size);
        try {
            for (CDORevisionKey revision : revisions) {
                CDORevisionKey key = CDORevisionUtil.copyRevisionKey((CDORevisionKey)revision);
                if (writtenRevisions.add(key)) {
                    out.writeBoolean(true);
                    out.writeCDORevision((CDORevision)revision, -1);
                } else {
                    out.writeBoolean(false);
                    out.writeCDORevisionKey(key);
                }
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }
}

