/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadChunkIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkIndication.class);
    private CDOID id;
    private CDOBranchVersion branchVersion;
    private EStructuralFeature feature;
    private int fromIndex;
    private int toIndex;

    public LoadChunkIndication(CDOServerProtocol protocol) {
        super(protocol, (short)9);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read revision ID: {0}", new Object[]{this.id});
        }
        this.branchVersion = in.readCDOBranchVersion();
        if (TRACER.isEnabled()) {
            TRACER.format("Read  branchVersion: {0}", new Object[]{this.branchVersion});
        }
        EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
        int featureID = in.readXInt();
        this.feature = eClass.getEStructuralFeature(featureID);
        if (TRACER.isEnabled()) {
            TRACER.format("Read feature: {0}", new Object[]{this.feature});
        }
        this.fromIndex = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read fromIndex: {0}", new Object[]{this.fromIndex});
        }
        this.toIndex = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read toIndex: {0}", new Object[]{this.toIndex});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalRepository repository = this.getRepository();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        InternalCDORevision revision = revisionManager.getRevisionByVersion(this.id, this.branchVersion, 0, true);
        repository.ensureChunk(revision, this.feature, this.fromIndex, this.toIndex + 1);
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        CDOList list = revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            Object value = list.get(i);
            type.writeValue(out, value);
            ++i;
        }
    }
}

