/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.genmodel;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.common.loader.IClassLoader;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.epackage.IProxyEPackage;
import org.eclipse.egf.core.epackage.IProxyERoot;
import org.eclipse.egf.core.epackage.ProxyFactory;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.platform.loader.BundleClassLoaderFactory;
import org.eclipse.egf.core.platform.loader.IBundleClassLoader;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.PlatformExtensionPointURI;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformGenModel
extends PlatformExtensionPointURI
implements IPlatformGenModel {
    private String _generatedPackage;
    private String _genModel;
    private URI _genModelURI;
    private static Map<URI, URI> workspaceGenModelLocationMap;
    private static Map<URI, IPlatformGenModel> nsURIToWorkspaceGenModel;
    private static Map<URI, URI> platformGenModelLocationMap;
    private static Map<URI, IPlatformGenModel> nsURIToPlatformGenModel;

    public static Map<URI, URI> getWorkspaceGenModelLocationMap() {
        if (workspaceGenModelLocationMap == null) {
            workspaceGenModelLocationMap = new HashMap<URI, URI>();
        }
        return workspaceGenModelLocationMap;
    }

    public static Map<URI, IPlatformGenModel> getWorkspacePlatformGenModels() {
        if (nsURIToWorkspaceGenModel == null) {
            nsURIToWorkspaceGenModel = new HashMap<URI, IPlatformGenModel>();
        }
        return nsURIToWorkspaceGenModel;
    }

    public static Map<URI, URI> getPlatformGenModelLocationMap() {
        if (platformGenModelLocationMap == null) {
            platformGenModelLocationMap = new HashMap<URI, URI>();
        }
        return platformGenModelLocationMap;
    }

    public static Map<URI, IPlatformGenModel> getPlatformGenModels() {
        if (nsURIToPlatformGenModel == null) {
            nsURIToPlatformGenModel = new HashMap<URI, IPlatformGenModel>();
        }
        return nsURIToPlatformGenModel;
    }

    @Override
    public URI getEPackageNsURI(URI uri) {
        return this.getEPackageNsURI(uri, null);
    }

    @Override
    public URI getEPackageNsURI(URI uri, Map<IPluginModelBase, IClassLoader> loaders) {
        if (uri == null) {
            return null;
        }
        try {
            if (this.getBundle() == null) {
                IBundleClassLoader loader = null;
                if (loaders != null) {
                    loader = loaders.get(this.getPluginModelBase());
                    if (loader == null) {
                        loader = BundleClassLoaderFactory.getBundleClassLoader((IPluginModelBase)this.getPluginModelBase());
                        loaders.put(this.getPluginModelBase(), (IClassLoader)loader);
                    }
                } else {
                    loader = BundleClassLoaderFactory.getBundleClassLoader((IPluginModelBase)this.getPluginModelBase());
                }
                return EMFHelper.getEPackageNsURI((IClassLoader)loader, (String)this.getGeneratedPackage(), (URI)uri);
            }
            return EMFHelper.getEPackageNsURI((EPackage)this.getEPackage(), (URI)uri);
        }
        catch (Throwable t) {
            EGFCorePlugin.getDefault().logError(t);
            return null;
        }
    }

    public static String getBasePackage(IPlatformGenModel genModel) {
        String classname = genModel.getGeneratedPackage();
        int index = classname.lastIndexOf(".");
        if (index == -1 || index == 0) {
            return null;
        }
        return classname.substring(0, index);
    }

    public PlatformGenModel(IPlatformBundle bundle, String uri, String className, String genModel) {
        super(bundle, uri);
        this._uri = URI.createURI((String)URI.decode((String)this.getId()));
        Assert.isNotNull((Object)className);
        Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
        Assert.isLegal((!bundle.isRuntime() ? 1 : 0) != 0);
        this._generatedPackage = className.trim();
        if (genModel != null && genModel.trim().length() != 0) {
            this._genModel = genModel.trim();
            this._genModelURI = URIHelper.getPlatformPluginURI((String)this.getPlatformBundle().getBundleId(), (String)URI.decode((String)this._genModel), (boolean)false);
            PlatformGenModel.getWorkspaceGenModelLocationMap().put(this.getNsURI(), this._genModelURI);
        }
        PlatformGenModel.getWorkspacePlatformGenModels().put(this.getNsURI(), this);
    }

    public PlatformGenModel(IPlatformBundle bundle, String uri, String uniqueIdentifier, int handleId, String className, String genModel) {
        super(bundle, uri, uniqueIdentifier, handleId);
        this._uri = URI.createURI((String)URI.decode((String)this.getId()));
        Assert.isNotNull((Object)className);
        Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
        Assert.isLegal((boolean)bundle.isRuntime());
        this._generatedPackage = className.trim();
        if (genModel != null && genModel.trim().length() != 0) {
            this._genModel = genModel.trim();
            this._genModelURI = URIHelper.getPlatformPluginURI((String)this.getPlatformBundle().getBundleId(), (String)URI.decode((String)this._genModel), (boolean)false);
            PlatformGenModel.getPlatformGenModelLocationMap().put(this.getNsURI(), this._genModelURI);
        }
        PlatformGenModel.getPlatformGenModels().put(this.getNsURI(), this);
    }

    protected void setPlatformBundle(IPlatformBundle bundle) {
        super.setPlatformBundle(bundle);
        if (this._genModelURI != null) {
            if (this.isRuntime()) {
                PlatformGenModel.getPlatformGenModelLocationMap().put(this.getNsURI(), this._genModelURI);
                EcorePlugin.getEPackageNsURIToGenModelLocationMap().put(this.getNsURI().toString(), this._genModelURI);
            } else {
                PlatformGenModel.getWorkspaceGenModelLocationMap().put(this.getNsURI(), this._genModelURI);
            }
        }
        if (this.isRuntime()) {
            PlatformGenModel.getPlatformGenModels().put(this.getNsURI(), this);
            EPackage.Registry.INSTANCE.put((Object)this.getNsURI().toString(), (Object)this.getEPackage());
        } else {
            PlatformGenModel.getWorkspacePlatformGenModels().put(this.getNsURI(), this);
        }
    }

    @Override
    public URI getNsURI() {
        return this.getURI();
    }

    @Override
    public String getGeneratedPackage() {
        return this._generatedPackage;
    }

    @Override
    public String getGenModel() {
        return this._genModel;
    }

    @Override
    public URI getGenModelURI() {
        return this._genModelURI;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof IPlatformGenModel)) {
            return false;
        }
        IPlatformGenModel platformGenModel = (IPlatformGenModel)object;
        if (!platformGenModel.getGeneratedPackage().equals(this.getGeneratedPackage())) {
            return false;
        }
        if (platformGenModel.getGenModel() == null && this.getGenModel() == null) {
            return true;
        }
        if (platformGenModel.getGenModel() == null || this.getGenModel() == null) {
            return false;
        }
        return platformGenModel.getGenModel().equals(this.getGenModel());
    }

    @Override
    public String getBasePackage() {
        return PlatformGenModel.getBasePackage(this);
    }

    @Override
    public IProxyEPackage getIProxyEPackage() {
        return this.getIProxyEPackage(null);
    }

    @Override
    public IProxyEPackage getIProxyEPackage(Map<IPluginModelBase, IClassLoader> loaders) {
        IProxyERoot wrapper = this.getIProxyERoot(loaders);
        if (wrapper != null && wrapper.getChildren().length == 1) {
            return wrapper.getChildren()[0];
        }
        return null;
    }

    @Override
    public IProxyERoot getIProxyERoot() {
        return this.getIProxyERoot(null);
    }

    @Override
    public IProxyERoot getIProxyERoot(Map<IPluginModelBase, IClassLoader> loaders) {
        try {
            if (this.getBundle() == null) {
                IBundleClassLoader loader = null;
                if (loaders != null) {
                    loader = loaders.get(this.getPluginModelBase());
                    if (loader == null) {
                        loader = BundleClassLoaderFactory.getBundleClassLoader((IPluginModelBase)this.getPluginModelBase());
                        loaders.put(this.getPluginModelBase(), (IClassLoader)loader);
                    }
                } else {
                    loader = BundleClassLoaderFactory.getBundleClassLoader((IPluginModelBase)this.getPluginModelBase());
                }
                return ProxyFactory.buildIProxyERoot((IClassLoader)loader, this);
            }
            return ProxyFactory.buildIProxyERoot(this);
        }
        catch (Throwable t) {
            EGFCorePlugin.getDefault().logError(t);
            return null;
        }
    }

    @Override
    public EPackage getEPackage() {
        if (this.getBundle() != null) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.getNsURI().toString());
            if (ePackage == null) {
                try {
                    Class javaClass = this.getBundle().loadClass(this._generatedPackage);
                    Field field = javaClass.getField("eINSTANCE");
                    Object result = field.get(null);
                    ePackage = (EPackage)result;
                    if (ePackage != null) {
                        EPackage.Registry.INSTANCE.put((Object)this.getNsURI().toString(), (Object)ePackage);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new WrappedException((Exception)e);
                }
                catch (IllegalAccessException e) {
                    throw new WrappedException((Exception)e);
                }
                catch (NoSuchFieldException e) {
                    throw new WrappedException((Exception)e);
                }
            }
            return ePackage;
        }
        throw new UnsupportedOperationException(NLS.bind((String)"EPackage couldn't be resolved ''{0}''", (Object)this.getNsURI()));
    }

    protected void dispose() {
        if (this.isRuntime()) {
            PlatformGenModel.getPlatformGenModelLocationMap().remove(this.getNsURI());
            PlatformGenModel.getPlatformGenModels().remove(this.getNsURI());
        } else {
            PlatformGenModel.getWorkspaceGenModelLocationMap().remove(this.getNsURI());
            PlatformGenModel.getWorkspacePlatformGenModels().remove(this.getNsURI());
        }
    }
}

