/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.List;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.ISelectionDialogListener;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TypeSelectionDialog
extends FilteredTypesSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.core.ui.dialogs.TypeSelectionDialog";
    private List<ISelectionDialogListener> _selectionListeners = new UniqueEList();

    public TypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaProject javaProject, int elementKinds) {
        super(parent, multi, context, javaProject != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}) : SearchEngine.createWorkspaceScope(), elementKinds, null);
        this.setTitle(CoreUIMessages.TypeSelection_dialogTitle);
        this.setMessage(CoreUIMessages.TypeSelectionDialog_dialogMessage);
        if (javaProject != null) {
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)javaProject.getProject().getName()));
        } else {
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_workspaceSeparatorLabel);
        }
    }

    public TypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaProject javaProject, int elementKinds, TypeSelectionExtension extension) {
        super(parent, multi, context, javaProject != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}) : SearchEngine.createWorkspaceScope(), elementKinds, extension);
        this.setTitle(NLS.bind((String)CoreUIMessages._UI_SelectType, (Object)extension.getFilterExtension()));
        this.setTitle(CoreUIMessages.TypeSelection_dialogTitle);
        this.setMessage(CoreUIMessages.TypeSelectionDialog_dialogMessage);
        if (javaProject != null) {
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)javaProject.getProject().getName()));
        } else {
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_workspaceSeparatorLabel);
        }
    }

    public TypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, int elementKinds) {
        super(parent, multi, context, SearchEngine.createWorkspaceScope(), elementKinds, null);
        this.setTitle(CoreUIMessages.TypeSelection_dialogTitle);
        this.setMessage(CoreUIMessages.TypeSelectionDialog_dialogMessage);
        this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_workspaceSeparatorLabel);
    }

    public TypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, int elementKinds, TypeSelectionExtension extension) {
        super(parent, multi, context, SearchEngine.createWorkspaceScope(), elementKinds, extension);
        this.setTitle(CoreUIMessages.TypeSelection_dialogTitle);
        this.setMessage(CoreUIMessages.TypeSelectionDialog_dialogMessage);
        this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_workspaceSeparatorLabel);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFCoreUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFCoreUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public boolean addSelectionListeners(ISelectionDialogListener listener) {
        if (listener == null) {
            return false;
        }
        return this._selectionListeners.add(listener);
    }

    public boolean removeSelectionListeners(ISelectionDialogListener listener) {
        if (listener == null) {
            return false;
        }
        return this._selectionListeners.remove(listener);
    }

    public void notifySelectionListeners(Object[] selected) {
        for (ISelectionDialogListener listener : this._selectionListeners) {
            listener.handleSelected(selected);
        }
    }

    public void setTitle(String title) {
        super.setTitle(title);
    }

    public int open() {
        return super.open();
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() != 0) {
            UniqueEList types = new UniqueEList();
            for (Object object : selection.toList()) {
                if (!(object instanceof TypeNameMatch)) continue;
                types.add(((TypeNameMatch)object).getType());
            }
            this.notifySelectionListeners(types.toArray());
        }
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }
}

