/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

public class GerritCredentials {
    private Credentials fCredentials = null;
    private boolean fIsOpenIdAuthenticated = false;
    private String fOpenIdProvider = null;
    private boolean fIsHttpAuthenticated = false;
    private Credentials fHttpCredentials = null;

    public GerritCredentials(String user, String pwd) {
        this.setGerritCredentials(user, pwd);
    }

    public String getUsername() {
        String name = null;
        if (this.fCredentials != null) {
            name = this.fCredentials.getUserPrincipal().getName();
        }
        return name;
    }

    public String getPassword() {
        String password = null;
        if (this.fCredentials != null) {
            password = this.fCredentials.getPassword();
        }
        return password;
    }

    private void setGerritCredentials(String user, String pwd) {
        if (user != null) {
            this.fCredentials = new UsernamePasswordCredentials(user, pwd);
        }
    }

    public Credentials getGerritCredentials() {
        return this.fCredentials;
    }

    public boolean isOpenIdAuthenticated() {
        return this.fIsOpenIdAuthenticated;
    }

    public void setOpenIdProvider(String provider) {
        boolean bl = this.fIsOpenIdAuthenticated = provider != null;
        if (this.fIsOpenIdAuthenticated) {
            this.fOpenIdProvider = provider;
        }
    }

    public String getOpenIdProvider() {
        return this.fOpenIdProvider;
    }

    public boolean isHttpAuthenticated() {
        return this.fIsHttpAuthenticated;
    }

    public void setHttpCredentials(String user, String pwd) {
        boolean bl = this.fIsHttpAuthenticated = user != null;
        if (this.fIsHttpAuthenticated) {
            this.fHttpCredentials = new UsernamePasswordCredentials(user, pwd);
        }
    }

    public Credentials getHttpCredentials() {
        return this.fHttpCredentials;
    }
}

