/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePreferenceConstants;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AlignConstAction
extends TextEditorAction {
    private static List<IASTDeclSpecifier> findMisalignedConsts(IASTNode rootNode, ICProject cProject) {
        boolean expectConstRight = CCorePreferenceConstants.getPreference((String)"astwriter.placeConstRightOfType", (ICProject)cProject, (boolean)false);
        MisalignedConstFinderVisitor misalignedConstVisitor = new MisalignedConstFinderVisitor(expectConstRight);
        rootNode.accept((ASTVisitor)misalignedConstVisitor);
        return misalignedConstVisitor.getDeclSpecifiersWithMisaligedConst();
    }

    public static void rewriteMisalignedConstSpecifiers(IASTNode node, IProgressMonitor monitor) throws CoreException {
        ICProject cProject = node.getTranslationUnit().getOriginatingTranslationUnit().getCProject();
        List<IASTDeclSpecifier> misalignedSpecifiers = AlignConstAction.findMisalignedConsts(node, cProject);
        if (!misalignedSpecifiers.isEmpty()) {
            IASTTranslationUnit ast = node.getTranslationUnit();
            ASTRewrite rewrite = ASTRewrite.create((IASTTranslationUnit)ast);
            for (IASTDeclSpecifier spec : misalignedSpecifiers) {
                rewrite.replace((IASTNode)spec, (IASTNode)spec, null);
            }
            rewrite.rewriteAST().perform(monitor);
        }
    }

    public AlignConstAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextSelection textSelection = this.getSelection();
        if (textSelection.isEmpty()) {
            return;
        }
        int offset = textSelection.getOffset();
        int length = textSelection.getLength();
        ITextEditor activeEditor = this.getTextEditor();
        this.alignConstQualifiers(offset, length, activeEditor);
    }

    private void alignConstQualifiers(int offset, int length, ITextEditor activeEditor) {
        ITranslationUnit translationUnit = (ITranslationUnit)CDTUITools.getEditorInputCElement(activeEditor.getEditorInput());
        try {
            IASTTranslationUnit ast = translationUnit.getAST(null, 6);
            IASTNode enclosingNode = ast.getNodeSelector(null).findEnclosingNode(offset, length);
            AlignConstAction.rewriteMisalignedConstSpecifiers(enclosingNode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    private static class MisalignedConstFinderVisitor
    extends ASTVisitor {
        private final boolean expectConstRight;
        private final List<IASTDeclSpecifier> declSpecifiersWithMisalignedConst = new ArrayList<IASTDeclSpecifier>();

        public MisalignedConstFinderVisitor(boolean expectConstRight) {
            this.shouldVisitDeclSpecifiers = true;
            this.expectConstRight = expectConstRight;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            if (declSpec.isConst()) {
                String rawSignature = declSpec.getRawSignature();
                rawSignature = rawSignature.replace("volatile", "").trim();
                if (!this.expectConstRight && !this.startsWithConst(rawSignature)) {
                    this.declSpecifiersWithMisalignedConst.add(declSpec);
                } else if (this.expectConstRight && !this.endsWithConst(rawSignature)) {
                    this.declSpecifiersWithMisalignedConst.add(declSpec);
                }
            }
            return 3;
        }

        private boolean startsWithConst(String signature) {
            if (!signature.startsWith("const")) {
                return false;
            }
            String candidate = signature.substring(0, "const".length() + 1);
            return !IdentifierHelper.checkIdentifierName(candidate).isCorrect();
        }

        private boolean endsWithConst(String signature) {
            if (!signature.endsWith("const")) {
                return false;
            }
            String candidate = signature.substring(signature.length() - "const".length() - 1);
            return !IdentifierHelper.checkIdentifierName(candidate).isCorrect();
        }

        public List<IASTDeclSpecifier> getDeclSpecifiersWithMisaligedConst() {
            return this.declSpecifiersWithMisalignedConst;
        }
    }
}

