/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.model;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProviderInfo;
import org.eclipse.cdt.testsrunner.internal.model.ModelMessages;
import org.eclipse.cdt.testsrunner.internal.model.TestModelManager;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelAccessor;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.cdt.testsrunner.model.ITestingSessionListener;
import org.eclipse.cdt.testsrunner.model.TestingException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;

public class TestingSession
implements ITestingSession {
    private ILaunch launch;
    private TestsRunnerProviderInfo testsRunnerProviderInfo;
    private ITestsRunnerProvider testsRunnerProvider;
    private TestModelManager modelManager;
    private int totalCounter = -1;
    private int currentCounter = 0;
    private Map<ITestItem.Status, Integer> statusCounters = new EnumMap<ITestItem.Status, Integer>(ITestItem.Status.class);
    private boolean hasErrors = false;
    private boolean wasStopped = false;
    private boolean finished = false;
    private String statusMessage = ModelMessages.TestingSession_starting_status;
    private long startTime;

    public TestingSession(ILaunch launch, TestsRunnerProviderInfo testsRunnerProviderInfo, TestingSession previousSession) {
        this.launch = launch;
        this.testsRunnerProviderInfo = testsRunnerProviderInfo;
        this.testsRunnerProvider = testsRunnerProviderInfo.instantiateTestsRunnerProvider();
        this.startTime = System.currentTimeMillis();
        if (previousSession != null) {
            TestCasesCounter testCasesCounter = new TestCasesCounter();
            previousSession.getModelAccessor().getRootSuite().visit(testCasesCounter);
            this.totalCounter = testCasesCounter.result;
        }
        ITestSuite rootTestSuite = previousSession != null ? previousSession.getModelAccessor().getRootSuite() : null;
        this.modelManager = new TestModelManager(rootTestSuite, testsRunnerProviderInfo.isAllowedTestingTimeMeasurement());
        this.modelManager.addChangesListener(new ITestingSessionListener(){

            @Override
            public void testingStarted() {
            }

            @Override
            public void testingFinished() {
                TestingSession.this.totalCounter = TestingSession.this.currentCounter;
            }

            @Override
            public void exitTestSuite(ITestSuite testSuite) {
            }

            @Override
            public void exitTestCase(ITestCase testCase) {
                ITestItem.Status testStatus = testCase.getStatus();
                TestingSession.this.statusCounters.put(testStatus, TestingSession.this.getCount(testStatus) + 1);
                TestingSession testingSession = TestingSession.this;
                testingSession.currentCounter = testingSession.currentCounter + 1;
                if (testStatus.isError()) {
                    TestingSession.this.hasErrors = true;
                }
            }

            @Override
            public void enterTestSuite(ITestSuite testSuite) {
            }

            @Override
            public void enterTestCase(ITestCase testCase) {
            }

            @Override
            public void childrenUpdate(ITestSuite parent) {
            }
        });
    }

    public void run(InputStream inputStream) {
        block3: {
            this.modelManager.testingStarted();
            try {
                this.testsRunnerProvider.run(this.modelManager, inputStream);
                if (!this.wasStopped()) {
                    double testingTime = this.getModelAccessor().getRootSuite().getTestingTime();
                    this.statusMessage = MessageFormat.format(ModelMessages.TestingSession_finished_status, testingTime / 1000.0);
                }
            }
            catch (TestingException e) {
                if (this.wasStopped()) break block3;
                this.statusMessage = e.getLocalizedMessage();
                this.hasErrors = true;
            }
        }
        this.finished = true;
        this.modelManager.testingFinished();
    }

    @Override
    public int getCurrentCounter() {
        return this.currentCounter;
    }

    @Override
    public int getTotalCounter() {
        return this.totalCounter;
    }

    @Override
    public int getCount(ITestItem.Status status) {
        Integer counterValue = this.statusCounters.get((Object)status);
        return counterValue == null ? 0 : counterValue;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public boolean wasStopped() {
        return this.wasStopped;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ITestModelAccessor getModelAccessor() {
        return this.modelManager;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    @Override
    public TestsRunnerProviderInfo getTestsRunnerProviderInfo() {
        return this.testsRunnerProviderInfo;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String getName() {
        String launchConfName = this.launch.getLaunchConfiguration().getName();
        String startTimeStr = DateFormat.getDateTimeInstance().format(new Date(this.startTime));
        return MessageFormat.format(ModelMessages.TestingSession_name_format, launchConfName, startTimeStr);
    }

    @Override
    public void stop() {
        if (!this.launch.isTerminated() && this.launch.canTerminate()) {
            try {
                this.launch.terminate();
                this.wasStopped = true;
                this.statusMessage = ModelMessages.TestingSession_stopped_status;
            }
            catch (DebugException e) {
                TestsRunnerPlugin.log(e);
            }
        }
    }

    private class TestCasesCounter
    implements IModelVisitor {
        public int result = 0;

        private TestCasesCounter() {
        }

        @Override
        public void visit(ITestCase testCase) {
            ++this.result;
        }

        @Override
        public void visit(ITestSuite testSuite) {
        }

        @Override
        public void visit(ITestMessage testMessage) {
        }

        @Override
        public void leave(ITestSuite testSuite) {
        }

        @Override
        public void leave(ITestCase testCase) {
        }

        @Override
        public void leave(ITestMessage testMessage) {
        }
    }
}

