/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.Messages;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl2;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IEvaluationService;

public class GdbReverseToggleCommand
extends AbstractDebugCommand
implements IChangeReverseMethodHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSession fSession;
    private IChangeReverseMethodHandler.ReverseDebugMethod fCurrentMethod;
    private IChangeReverseMethodHandler.ReverseDebugMethod fPreviousMethod;
    private IChangeReverseMethodHandler.ReverseDebugMethod fNextMethod;

    public GdbReverseToggleCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
        this.fSession = session;
        this.fCurrentMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        this.fPreviousMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        this.fNextMethod = IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    GdbReverseToggleCommand.this.fSession.addServiceEventListener((Object)GdbReverseToggleCommand.this, null);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    GdbReverseToggleCommand.this.fSession.removeServiceEventListener((Object)GdbReverseToggleCommand.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, final IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        IDMContext dmc = ((IDMVMContext)targets[0]).getDMContext();
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc == null) {
            return;
        }
        Query<Object> setReverseMode = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> rm) {
                IReverseRunControl2 runControl = (IReverseRunControl2)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl2.class);
                if (runControl != null) {
                    String defaultValue;
                    final IChangeReverseMethodHandler.ReverseDebugMethod newMethod = GdbReverseToggleCommand.this.fNextMethod == IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE ? ((defaultValue = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb..reversedebugpref.tracemethodHardware", "UseGdbTrace", null)).equals("UseBranchTrace") ? IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE : (defaultValue.equals("UseProcessorTrace") ? IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE : IChangeReverseMethodHandler.ReverseDebugMethod.GDB_TRACE)) : GdbReverseToggleCommand.this.fNextMethod;
                    runControl.enableReverseMode(controlDmc, newMethod, new RequestMonitor((Executor)GdbReverseToggleCommand.this.fExecutor, (RequestMonitor)rm){

                        public void handleError() {
                            super.handleError();
                            if (newMethod == IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE) {
                                request.setStatus((IStatus)new Status(0, "org.eclipse.cdt.dsf.gdb", 1, Messages.GdbReverseDebugging_ProcessorTraceReverseDebugNotAvailable, null));
                            } else if (newMethod == IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE || newMethod == IChangeReverseMethodHandler.ReverseDebugMethod.GDB_TRACE) {
                                request.setStatus((IStatus)new Status(0, "org.eclipse.cdt.dsf.gdb", 1, Messages.GdbReverseDebugging_HardwareReverseDebugNotAvailable, null));
                            } else {
                                request.setStatus((IStatus)new Status(0, "org.eclipse.cdt.dsf.gdb", 1, Messages.GdbReverseDebugging_ReverseDebugNotAvailable, null));
                            }
                        }
                    });
                } else {
                    final IReverseRunControl runControl_old = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                    if (runControl_old != null) {
                        if (GdbReverseToggleCommand.this.fCurrentMethod != IChangeReverseMethodHandler.ReverseDebugMethod.OFF && GdbReverseToggleCommand.this.fCurrentMethod != IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE) {
                            runControl_old.enableReverseMode(controlDmc, false, rm);
                            request.setStatus((IStatus)new Status(0, "org.eclipse.cdt.dsf.gdb", 1, Messages.GdbReverseDebugging_HardwareReverseDebugNotAvailable, null));
                            return;
                        }
                        runControl_old.isReverseModeEnabled(controlDmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbReverseToggleCommand.this.fExecutor, rm){

                            public void handleSuccess() {
                                runControl_old.enableReverseMode(controlDmc, (Boolean)this.getData() == false, (RequestMonitor)rm);
                            }
                        });
                    } else {
                        rm.done();
                    }
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)setReverseMode);
            setReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        IDMContext dmc = ((IDMVMContext)targets[0]).getDMContext();
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class);
        if (controlDmc == null && execDmc == null) {
            return false;
        }
        Query<Boolean> canSetReverseMode = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null && runControl instanceof IRunControl && ((IRunControl)runControl).isSuspended(execDmc)) {
                    runControl.canEnableReverseMode(controlDmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canSetReverseMode);
            return (Boolean)canSetReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

    public boolean toggleNeedsUpdating() {
        return true;
    }

    public boolean isReverseToggled(Object context) {
        IDMContext dmc;
        if (context instanceof IDMContext) {
            dmc = (IDMContext)context;
        } else if (context instanceof IDMVMContext) {
            dmc = ((IDMVMContext)context).getDMContext();
        } else {
            return false;
        }
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc == null) {
            return false;
        }
        Query<Boolean> isToggledQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(controlDmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)isToggledQuery);
            return (Boolean)isToggledQuery.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IReverseRunControl.IReverseModeChangedDMEvent e) {
        new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ICommandService commandService;
                IEvaluationService exprService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                if (exprService != null) {
                    exprService.requestEvaluation("org.eclipse.cdt.debug.ui.isReverseDebuggingEnabled");
                }
                if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
                    commandService.refreshElements("org.eclipse.cdt.debug.ui.command.reverseToggle", null);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void setReverseDebugMethod(IChangeReverseMethodHandler.ReverseDebugMethod traceMethod) {
        this.fNextMethod = traceMethod;
    }

    public IChangeReverseMethodHandler.ReverseDebugMethod getReverseDebugMethod(Object context) {
        IDMContext dmc;
        if (context instanceof IDMContext) {
            dmc = (IDMContext)context;
        } else if (context instanceof IDMVMContext) {
            dmc = ((IDMVMContext)context).getDMContext();
        } else {
            return IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        }
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc == null) {
            return IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
        }
        Query<IChangeReverseMethodHandler.ReverseDebugMethod> reverseMethodQuery = new Query<IChangeReverseMethodHandler.ReverseDebugMethod>(){

            public void execute(final DataRequestMonitor<IChangeReverseMethodHandler.ReverseDebugMethod> rm) {
                IReverseRunControl2 runControl = (IReverseRunControl2)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl2.class);
                if (runControl != null) {
                    runControl.getReverseTraceMethod(controlDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IChangeReverseMethodHandler.ReverseDebugMethod>(rm){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                rm.done((Object)IChangeReverseMethodHandler.ReverseDebugMethod.OFF);
                            } else {
                                IChangeReverseMethodHandler.ReverseDebugMethod method = (IChangeReverseMethodHandler.ReverseDebugMethod)this.getData();
                                if (method == IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE || method == IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE || method == IChangeReverseMethodHandler.ReverseDebugMethod.GDB_TRACE) {
                                    method = IChangeReverseMethodHandler.ReverseDebugMethod.HARDWARE;
                                }
                                rm.done((Object)method);
                            }
                        }
                    });
                } else {
                    IReverseRunControl runControl_old = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                    if (runControl_old != null) {
                        runControl_old.isReverseModeEnabled(controlDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(rm){

                            protected void handleCompleted() {
                                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                                    rm.done((Object)IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE);
                                } else {
                                    rm.done((Object)IChangeReverseMethodHandler.ReverseDebugMethod.OFF);
                                }
                            }
                        });
                    } else {
                        rm.done((Object)IChangeReverseMethodHandler.ReverseDebugMethod.OFF);
                    }
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)reverseMethodQuery);
            IChangeReverseMethodHandler.ReverseDebugMethod currMethod = (IChangeReverseMethodHandler.ReverseDebugMethod)reverseMethodQuery.get(500L, TimeUnit.MILLISECONDS);
            if (currMethod != this.fCurrentMethod) {
                this.fPreviousMethod = this.fCurrentMethod;
                this.fCurrentMethod = currMethod;
            }
            return this.fCurrentMethod;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return IChangeReverseMethodHandler.ReverseDebugMethod.OFF;
    }

    public IChangeReverseMethodHandler.ReverseDebugMethod getPreviousReverseDebugMethod(Object context) {
        return this.fPreviousMethod;
    }
}

