/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class FontCanvas
extends Canvas
implements PaintListener,
DisposeListener {
    private FontDefinition fdCurrent = null;
    private ColorDefinition cdCurrent = null;
    private boolean bUseColor = true;
    private boolean bUseAlignment = true;
    private boolean bUseSize = true;
    private IDeviceRenderer idr;
    private int preferredWidth = 0;

    public FontCanvas(Composite parent, int style, FontDefinition fdSelected, ColorDefinition cdSelected, boolean bUseSize, boolean bUseColor, boolean bUseAlignment) {
        super(parent, style);
        this.setSize(parent.getClientArea().x, parent.getClientArea().x);
        this.fdCurrent = fdSelected == null ? FontDefinitionImpl.createEmpty() : fdSelected;
        this.cdCurrent = cdSelected;
        this.bUseColor = bUseColor;
        this.bUseAlignment = bUseAlignment;
        this.bUseSize = bUseSize;
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            this.idr = null;
            WizardBase.displayException((Throwable)pex);
        }
        this.addDisposeListener(this);
        this.addPaintListener(this);
        GC gc = new GC((Drawable)this);
        Event e = new Event();
        e.gc = gc;
        this.notifyListeners(9, e);
    }

    public void setFontDefinition(FontDefinition fdSelected) {
        this.fdCurrent = fdSelected;
    }

    public void setColor(ColorDefinition cdSelected) {
        this.cdCurrent = cdSelected;
    }

    public void paintControl(PaintEvent pe) {
        if (this.idr != null && this.fdCurrent != null && this.bUseSize) {
            ColorDefinition cdBack;
            ColorDefinition cdFore;
            this.idr.setProperty("device.output.context", (Object)pe.gc);
            TextRenderEvent tre = new TextRenderEvent((Object)this);
            tre.setAction(3);
            TextAlignment ta = TextAlignmentImpl.create();
            if (this.fdCurrent != null) {
                ta.setHorizontalAlignment(ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getHorizontalAlignment());
                ta.setVerticalAlignment(ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getVerticalAlignment());
            } else {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
            tre.setBlockAlignment(ta);
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)(this.getSize().x - 3), (double)(this.getSize().y - 3));
            tre.setBlockBounds(bo);
            String fontName = ChartUIUtil.getFontName((FontDefinition)this.fdCurrent);
            Text tx = TextImpl.create((String)fontName);
            FontDefinition fd = this.fdCurrent.copyInstance();
            fd.setName(fontName);
            if (!fd.isSetSize()) {
                fd.setSize(9.0f);
            }
            tx.setFont(fd);
            if (!this.isEnabled()) {
                Color cFore = Display.getCurrent().getSystemColor(16);
                Color cBack = Display.getCurrent().getSystemColor(22);
                cdFore = ColorDefinitionImpl.create((int)cFore.getRed(), (int)cFore.getGreen(), (int)cFore.getBlue());
                cdBack = ColorDefinitionImpl.create((int)cBack.getRed(), (int)cBack.getGreen(), (int)cBack.getBlue());
            } else {
                Color cBack = Display.getCurrent().getSystemColor(25);
                cdBack = ColorDefinitionImpl.create((int)cBack.getRed(), (int)cBack.getGreen(), (int)cBack.getBlue());
                if (this.cdCurrent != null && this.bUseColor) {
                    cdFore = this.cdCurrent.copyInstance();
                } else {
                    Color cFore = Display.getCurrent().getSystemColor(24);
                    cdFore = ColorDefinitionImpl.create((int)cFore.getRed(), (int)cFore.getGreen(), (int)cFore.getBlue());
                }
            }
            tx.setColor(cdFore);
            Label lb = LabelImpl.create();
            lb.setBackground((Fill)cdBack);
            lb.setCaption(tx);
            tre.setLabel(lb);
            RectangleRenderEvent rre = new RectangleRenderEvent((Object)this);
            rre.setBounds(bo);
            rre.setBackground((Fill)cdBack);
            try {
                this.idr.fillRectangle(rre);
                this.idr.drawText(tre);
            }
            catch (ChartException chartException) {}
            return;
        }
        Font fSize = null;
        Font fCurrent = null;
        Color cFore = null;
        Color cBack = null;
        GC gc = pe.gc;
        gc.setAdvanced(true);
        Font fOld = gc.getFont();
        if (!this.isEnabled()) {
            cFore = Display.getCurrent().getSystemColor(16);
            cBack = Display.getCurrent().getSystemColor(22);
        } else {
            cBack = Display.getCurrent().getSystemColor(25);
            cFore = this.cdCurrent != null && this.bUseColor && this.cdCurrent.getTransparency() > 0 ? new Color((Device)this.getDisplay(), this.cdCurrent.getRed(), this.cdCurrent.getGreen(), this.cdCurrent.getBlue()) : Display.getCurrent().getSystemColor(24);
        }
        gc.setForeground(cFore);
        gc.setBackground(cBack);
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.fdCurrent != null) {
            int iStyle = this.fdCurrent.isSetBold() && this.fdCurrent.isBold() ? 1 : 0;
            iStyle |= this.fdCurrent.isSetItalic() && this.fdCurrent.isItalic() ? 2 : iStyle;
            String sFontName = ChartUIUtil.getFontName((FontDefinition)this.fdCurrent);
            if (!this.bUseSize) {
                gc.setClipping(2, 2, this.getSize().x - 40, 26);
                fCurrent = new Font((Device)this.getDisplay(), ChartUIUtil.getFontName((FontDefinition)this.fdCurrent), fOld.getFontData()[0].getHeight(), iStyle);
            } else {
                fCurrent = new Font((Device)this.getDisplay(), ChartUIUtil.getFontName((FontDefinition)this.fdCurrent), this.fdCurrent.isSetSize() ? (int)this.fdCurrent.getSize() : 9, iStyle);
            }
            gc.setFont(fCurrent);
            int iStartX = 5;
            int iStartY = 3;
            if (this.bUseAlignment) {
                if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getHorizontalAlignment().equals((Object)HorizontalAlignment.LEFT_LITERAL)) {
                    iStartX = 5;
                } else if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getHorizontalAlignment().equals((Object)HorizontalAlignment.CENTER_LITERAL)) {
                    iStartX = this.getSize().x / 2 - this.getStringWidth((GC)gc, (String)sFontName).x / 2;
                } else if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getHorizontalAlignment().equals((Object)HorizontalAlignment.RIGHT_LITERAL)) {
                    iStartX = this.getSize().x - this.getStringWidth((GC)gc, (String)sFontName).x - 5;
                }
                if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getVerticalAlignment().equals((Object)VerticalAlignment.TOP_LITERAL)) {
                    iStartY = 3;
                } else if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getVerticalAlignment().equals((Object)VerticalAlignment.CENTER_LITERAL)) {
                    iStartY = this.getSize().y / 2;
                    iStartY = this.bUseSize ? (iStartY -= this.getStringWidth((GC)gc, (String)sFontName).y / 2) : (iStartY -= 15);
                } else if (ChartUIUtil.getFontTextAlignment((FontDefinition)this.fdCurrent).getVerticalAlignment().equals((Object)VerticalAlignment.BOTTOM_LITERAL)) {
                    iStartY = this.getSize().y;
                    iStartY = this.bUseSize ? (iStartY -= this.getStringWidth((GC)gc, (String)sFontName).y + 5) : (iStartY -= 30);
                }
            }
            gc.drawText(sFontName, iStartX, iStartY);
            if (this.fdCurrent.isUnderline()) {
                gc.drawLine(iStartX, iStartY + this.getStringWidth((GC)gc, (String)sFontName).y - gc.getFontMetrics().getDescent(), iStartX + this.getStringWidth((GC)gc, (String)sFontName).x - gc.getFontMetrics().getDescent(), iStartY + this.getStringWidth((GC)gc, (String)sFontName).y - gc.getFontMetrics().getDescent());
            }
            if (this.fdCurrent.isStrikethrough()) {
                gc.drawLine(iStartX, iStartY + this.getStringWidth((GC)gc, (String)sFontName).y / 2 + 1, iStartX + this.getStringWidth((GC)gc, (String)sFontName).x, iStartY + this.getStringWidth((GC)gc, (String)sFontName).y / 2 + 1);
            }
            if (!this.bUseSize) {
                gc.setClipping(1, 1, this.getSize().x, this.getSize().y);
                fSize = new Font((Device)this.getDisplay(), "Sans-Serif", fOld.getFontData()[0].getHeight(), 0);
                gc.setFont(fSize);
                String sizeString = "(" + (this.fdCurrent.isSetSize() ? String.valueOf((int)this.fdCurrent.getSize()) : ChartUIUtil.FONT_AUTO) + ")";
                Point pt = gc.textExtent(sizeString);
                gc.drawText(sizeString, this.getSize().x - pt.x - this.getBorderWidth() - 2, (this.getSize().y - pt.y) / 2 - 1);
                fSize.dispose();
                this.preferredWidth = this.getStringWidth((GC)gc, (String)sFontName).x + this.getStringWidth((GC)gc, (String)sizeString).x + 5 + iStartX;
            }
            fCurrent.dispose();
        }
        if (this.isEnabled()) {
            cFore.dispose();
        }
        gc.setFont(fOld);
    }

    private Point getStringWidth(GC gc, String sText) {
        return gc.textExtent(sText);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.idr != null) {
            this.idr.dispose();
            this.idr = null;
        }
    }
}

