/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.internal.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.extension.ContentGeneratorExtensionFactoryRegistry;

public class BindingGenerator
extends BaseGenerator {
    private WSDLFactory factory = WSDLFactory.eINSTANCE;
    private Binding binding;

    public BindingGenerator(Definition definition, Binding binding) {
        this.definition = definition;
        this.binding = binding;
        this.contentGenerator = BindingGenerator.getContentGenerator(binding);
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public BindingGenerator(Definition definition, Binding binding, String namespace) {
        this.definition = definition;
        this.binding = binding;
        this.contentGenerator = BindingGenerator.getContentGenerator(namespace);
    }

    public static ContentGenerator getContentGenerator(Binding binding) {
        if (binding == null) {
            return null;
        }
        String namespace = null;
        EList eeList = binding.getEExtensibilityElements();
        if (eeList.size() > 0) {
            ExtensibilityElement ee = (ExtensibilityElement)eeList.get(0);
            namespace = ee.getElement().getNamespaceURI();
            return BindingGenerator.getContentGenerator(namespace);
        }
        return null;
    }

    public static ContentGenerator getContentGenerator(String namespace) {
        ContentGenerator contentGen = null;
        if (namespace != null) {
            ContentGeneratorExtensionFactoryRegistry factoryRegistry = ContentGeneratorExtensionFactoryRegistry.getInstance();
            contentGen = factoryRegistry.getGeneratorClassFromNamespace(namespace);
        }
        return contentGen;
    }

    private Binding createEmptyBinding(String localName) {
        Binding newBinding = WSDLFactory.eINSTANCE.createBinding();
        newBinding.setQName(new QName(this.definition.getTargetNamespace(), localName));
        newBinding.setEnclosingDefinition(this.definition);
        this.definition.addBinding(newBinding);
        return newBinding;
    }

    public Binding generateBinding() {
        block21: {
            try {
                if (this.binding == null) {
                    this.binding = this.createEmptyBinding(this.getName());
                }
                if (this.getName() != null && !this.binding.getQName().getLocalPart().equals(this.getName())) {
                    this.binding.setQName(new QName(this.binding.getQName().getNamespaceURI(), this.getName()));
                }
                if (this.getRefName() != null) {
                    PortType portType = this.getPortType();
                    this.binding.setEPortType(portType);
                    if (portType == null) {
                        this.binding.getElement().setAttribute("type", "");
                    }
                }
                EList bindingOperations = this.binding.getEBindingOperations();
                PortType portType = this.binding.getEPortType();
                if (!this.getOverwrite()) {
                    if (portType == null) {
                        return this.binding;
                    }
                    List operations = portType.getOperations();
                    ArrayList<Operation> newBindingOpsNeeded = new ArrayList<Operation>();
                    int index = 0;
                    while (index < operations.size()) {
                        Operation operation = (Operation)operations.get(index);
                        boolean foundMatch = false;
                        Iterator bindingOperationsIt = bindingOperations.iterator();
                        while (bindingOperationsIt.hasNext()) {
                            BindingOperation bindingOperation = (BindingOperation)bindingOperationsIt.next();
                            if (!this.namesEqual(bindingOperation.getName(), operation.getName())) continue;
                            foundMatch = true;
                            break;
                        }
                        if (!foundMatch) {
                            newBindingOpsNeeded.add(operation);
                        }
                        ++index;
                    }
                    List newBindingOps = this.createNewBindingOperations(newBindingOpsNeeded);
                    if (!newBindingOps.isEmpty()) {
                        this.addRequiredNamespaces(this.binding);
                    }
                    Iterator newBindingOpsIt = newBindingOps.iterator();
                    while (newBindingOpsIt.hasNext()) {
                        BindingOperation newBindingOp = (BindingOperation)newBindingOpsIt.next();
                        this.generateBindingOperation(newBindingOp);
                        this.generateBindingOperationContent(newBindingOp);
                    }
                    this.generateBindingContent(this.binding);
                    break block21;
                }
                if (portType == null) {
                    bindingOperations.clear();
                    return this.binding;
                }
                this.addRequiredNamespaces(this.binding);
                List operations = portType.getOperations();
                int index = 0;
                while (index < bindingOperations.size()) {
                    BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(index);
                    boolean foundMatch = false;
                    Iterator operationsIt = operations.iterator();
                    while (operationsIt.hasNext()) {
                        Operation operation = (Operation)operationsIt.next();
                        if (!this.namesEqual(bindingOperation.getName(), operation.getName())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) {
                        bindingOperations.remove(index);
                        --index;
                    }
                    ++index;
                }
                ArrayList<Operation> bindingOperationsNeeded = new ArrayList<Operation>();
                int index2 = 0;
                while (index2 < operations.size()) {
                    Operation operation = (Operation)operations.get(index2);
                    boolean foundMatch = false;
                    Iterator bindingOperationsIt = bindingOperations.iterator();
                    while (bindingOperationsIt.hasNext()) {
                        BindingOperation bindingOperation = (BindingOperation)bindingOperationsIt.next();
                        if (!this.namesEqual(bindingOperation.getName(), operation.getName())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) {
                        bindingOperationsNeeded.add(operation);
                    }
                    ++index2;
                }
                this.createNewBindingOperations(bindingOperationsNeeded);
                Iterator bindingOperationsIt = this.binding.getEBindingOperations().iterator();
                while (bindingOperationsIt.hasNext()) {
                    this.generateBindingOperation((BindingOperation)bindingOperationsIt.next());
                }
                this.generateBindingContent(this.binding);
                return this.binding;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List createNewBindingOperations(List operations) {
        ArrayList<BindingOperation> newBindingOps = new ArrayList<BindingOperation>();
        Iterator neededBindingOperationsIt = operations.iterator();
        while (neededBindingOperationsIt.hasNext()) {
            Operation operation = (Operation)neededBindingOperationsIt.next();
            BindingOperation newBindingOperation = this.factory.createBindingOperation();
            newBindingOperation.setEOperation(operation);
            newBindingOperation.setName(operation.getName());
            this.binding.addBindingOperation(newBindingOperation);
            newBindingOps.add(newBindingOperation);
        }
        return newBindingOps;
    }

    private void generateBindingOperation(BindingOperation bindingOperation) {
        BindingInput bindingInput = bindingOperation.getEBindingInput();
        BindingOutput bindingOutput = bindingOperation.getEBindingOutput();
        EList bindingFaults = bindingOperation.getEBindingFaults();
        Operation operation = bindingOperation.getEOperation();
        Input input = operation.getEInput();
        Output output = operation.getEOutput();
        EList faults = operation.getEFaults();
        if (!this.namesEqual(bindingOperation.getName(), operation.getName())) {
            bindingOperation.setName(operation.getName());
        }
        if (output == null) {
            bindingOperation.setBindingOutput(null);
        } else if (bindingOutput == null) {
            BindingOutput newBindingOutput = this.factory.createBindingOutput();
            newBindingOutput.setEOutput(output);
            newBindingOutput.setName(output.getName());
            bindingOperation.setBindingOutput(newBindingOutput);
        } else if (!this.namesEqual(bindingOutput.getName(), output.getName())) {
            bindingOutput.setName(output.getName());
        }
        this.generateBindingOutputContent(bindingOperation.getEBindingOutput());
        if (input == null) {
            bindingOperation.setBindingInput(null);
        } else if (bindingInput == null) {
            BindingInput newBindingInput = this.factory.createBindingInput();
            newBindingInput.setEInput(input);
            newBindingInput.setName(input.getName());
            bindingOperation.setBindingInput(newBindingInput);
        } else if (!this.namesEqual(bindingInput.getName(), input.getName())) {
            bindingInput.setName(input.getName());
        }
        this.generateBindingInputContent(bindingOperation.getEBindingInput());
        int index = 0;
        while (index < bindingFaults.size()) {
            BindingFault bindingFault = (BindingFault)bindingFaults.get(index);
            boolean foundMatch = false;
            Iterator faultsIt = faults.iterator();
            while (faultsIt.hasNext()) {
                Fault fault = (Fault)faultsIt.next();
                if (!this.namesEqual(bindingFault.getName(), fault.getName())) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                bindingFaults.remove(index);
                --index;
            }
            ++index;
        }
        ArrayList<Fault> bindingFaultsNeeded = new ArrayList<Fault>();
        int index2 = 0;
        while (index2 < faults.size()) {
            Fault fault = (Fault)faults.get(index2);
            boolean foundMatch = false;
            Iterator bindingFaultsIt = bindingFaults.iterator();
            while (bindingFaultsIt.hasNext()) {
                BindingFault bindingFault = (BindingFault)bindingFaultsIt.next();
                if (!this.namesEqual(bindingFault.getName(), fault.getName())) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                bindingFaultsNeeded.add(fault);
            }
            ++index2;
        }
        Iterator neededBindingFaultsIt = bindingFaultsNeeded.iterator();
        while (neededBindingFaultsIt.hasNext()) {
            Fault fault = (Fault)neededBindingFaultsIt.next();
            BindingFault newBindingFault = this.factory.createBindingFault();
            newBindingFault.setEFault(fault);
            newBindingFault.setName(fault.getName());
            bindingOperation.addBindingFault(newBindingFault);
        }
        Iterator faultContentIt = bindingOperation.getEBindingFaults().iterator();
        while (faultContentIt.hasNext()) {
            BindingFault bindingFault = (BindingFault)faultContentIt.next();
            this.generateBindingFaultContent(bindingFault);
        }
        this.generateBindingOperationContent(bindingOperation);
    }

    private boolean namesEqual(String name1, String name2) {
        boolean match = false;
        match = name1 != null ^ name2 != null ? false : (name1 != null && name2 != null ? name1.equals(name2) : true);
        return match;
    }

    protected void generateBindingContent(Binding binding) {
        if (this.contentGenerator != null) {
            if (this.getOverwrite() || binding.getEExtensibilityElements().size() == 0) {
                this.contentGenerator.generateBindingContent(binding, binding.getEPortType());
            }
        } else {
            this.removeExtensibilityElements(binding);
        }
    }

    protected void generateBindingOperationContent(BindingOperation bindingOperation) {
        if (bindingOperation != null && this.contentGenerator != null) {
            this.contentGenerator.generateBindingOperationContent(bindingOperation, bindingOperation.getEOperation());
        } else {
            this.removeExtensibilityElements(bindingOperation);
        }
    }

    protected void generateBindingInputContent(BindingInput bindingInput) {
        if (bindingInput != null && this.contentGenerator != null) {
            this.contentGenerator.generateBindingInputContent(bindingInput, bindingInput.getEInput());
        } else {
            this.removeExtensibilityElements(bindingInput);
        }
    }

    protected void generateBindingOutputContent(BindingOutput bindingOutput) {
        if (bindingOutput != null && this.contentGenerator != null) {
            this.contentGenerator.generateBindingOutputContent(bindingOutput, bindingOutput.getEOutput());
        } else {
            this.removeExtensibilityElements(bindingOutput);
        }
    }

    protected void generateBindingFaultContent(BindingFault bindingFault) {
        if (bindingFault != null && this.contentGenerator != null) {
            this.contentGenerator.generateBindingFaultContent(bindingFault, bindingFault.getEFault());
        } else {
            this.removeExtensibilityElements(bindingFault);
        }
    }

    private void removeExtensibilityElements(ExtensibleElement ee) {
        if (ee != null) {
            ee.getEExtensibilityElements().clear();
        }
    }

    public void generatePortContent() {
        if (this.binding != null && this.contentGenerator != null) {
            ArrayList<Port> portsToUpdate = new ArrayList<Port>();
            Iterator servicesIt = this.binding.getEnclosingDefinition().getEServices().iterator();
            while (servicesIt.hasNext()) {
                Service service = (Service)servicesIt.next();
                Iterator portsIt = service.getEPorts().iterator();
                while (portsIt.hasNext()) {
                    Port port = (Port)portsIt.next();
                    if (!this.binding.equals(port.getEBinding())) continue;
                    portsToUpdate.add(port);
                }
            }
            Iterator portsToUpdateIt = portsToUpdate.iterator();
            while (portsToUpdateIt.hasNext()) {
                this.contentGenerator.generatePortContent((Port)portsToUpdateIt.next());
            }
        }
    }

    protected void addRequiredNamespaces(Binding binding) {
        if (this.contentGenerator != null) {
            String[] namespaceNames = this.contentGenerator.getRequiredNamespaces();
            String[] preferredPrefixes = new String[namespaceNames.length];
            int index = 0;
            while (index < namespaceNames.length) {
                preferredPrefixes[index] = this.contentGenerator.getPreferredNamespacePrefix(namespaceNames[index]);
                ++index;
            }
            Map map = binding.getEnclosingDefinition().getNamespaces();
            int i = 0;
            while (i < namespaceNames.length) {
                String namespace = namespaceNames[i];
                if (!map.containsValue(namespace)) {
                    String prefix;
                    String string = prefix = i < preferredPrefixes.length ? preferredPrefixes[i] : "p0";
                    if (map.containsKey(prefix)) {
                        prefix = this.computeUniquePrefix("p", map);
                    }
                    binding.getEnclosingDefinition().addNamespace(prefix, namespace);
                }
                ++i;
            }
        }
    }

    private String computeUniquePrefix(String base, Map table) {
        int i = 0;
        String prefix = base;
        while (table.containsKey(prefix)) {
            prefix = String.valueOf(base) + i;
            ++i;
        }
        return prefix;
    }

    private PortType getPortType() {
        if (this.getRefName().equals("")) {
            return null;
        }
        if (this.getRefName() != null) {
            Iterator portTypeIt = this.definition.getEPortTypes().iterator();
            while (portTypeIt.hasNext()) {
                PortType pt = (PortType)portTypeIt.next();
                List prefixedNames = this.getPrefixedNames(pt);
                if (!prefixedNames.contains(this.getRefName())) continue;
                return pt;
            }
        }
        return this.binding.getEPortType();
    }

    private List getPrefixedNames(PortType portType) {
        ArrayList<String> prefixedNames = new ArrayList<String>();
        String currentPortTypeName = portType.getQName().getLocalPart();
        String currentNamespace = portType.getQName().getNamespaceURI();
        Map namespaceMap = this.definition.getNamespaces();
        Iterator keys = namespaceMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = namespaceMap.get(key);
            if (!currentNamespace.equals(value)) continue;
            prefixedNames.add(key + ":" + currentPortTypeName);
        }
        return prefixedNames;
    }
}

