/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.RGBColor;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.swtchart.LineStyle;

public class XYChartLegendImageProvider
implements ILegendImageProvider {
    private final TmfCommonXAxisChartViewer fChartViewer;

    public XYChartLegendImageProvider(TmfCommonXAxisChartViewer chartViewer) {
        this.fChartViewer = chartViewer;
    }

    @Override
    public Image getLegendImage(int imageHeight, int imageWidth, @NonNull String name) {
        IYAppearance appearance = this.fChartViewer.getSeriesAppearance(name);
        RGBColor rgb = appearance.getColor();
        Color lineColor = new Color((Device)Display.getDefault(), rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        Color background = Display.getDefault().getSystemColor(1);
        PaletteData palette = new PaletteData(new RGB[]{background.getRGB(), lineColor.getRGB()});
        ImageData imageData = new ImageData(imageWidth, imageHeight, 8, palette);
        imageData.transparentPixel = 0;
        Image image = new Image((Device)Display.getDefault(), imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, imageWidth, imageHeight);
        gc.setForeground(lineColor);
        gc.setLineWidth(appearance.getWidth());
        gc.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()).ordinal());
        gc.drawLine(0, imageHeight / 2, imageWidth, imageHeight / 2);
        gc.dispose();
        lineColor.dispose();
        return image;
    }
}

